#include <cstring>
#include <cctype>
#include <iostream>
#include <string>
#include <vector>

using namespace std;

const int VAR_LENGTH = 20;

/**
   Przygotowuje szablon listu do korespondencji masowej.
   @param letter ciąg z symbolami zastępczymi 0 ... 9 (które zostaną
   zamienione na puste znaki końca)
   @param vars dwuwymiarowa tablica przechowująca zmienne części listu
   @return wektor fragmentów tekstu, zawierający na przemian ciągi
   z szablonu listu i z tablicy zmiennych
 */
vector<char*> prepare_mailing(char* letter, char vars[][VAR_LENGTH])
{
   vector<char*> fragments;
   char* fragment_start = letter;
   for (char* p = letter; *p != '\0'; p++)
   {
      if (isdigit(*p))
      {
         fragments.push_back(fragment_start);
         fragment_start = p + 1;
         int var_index = *p - '0';
         fragments.push_back(vars[var_index]);
         *p = '\0';
      }
   }
   fragments.push_back(fragment_start);
   return fragments;
}


int main()
{
   char variable_parts[10][VAR_LENGTH];

   strcpy(variable_parts[0], "Pani");
   strcpy(variable_parts[1], "Sabina");
   strcpy(variable_parts[2], "Kowalska");
   strcpy(variable_parts[3], "ul. Głowna 123");
   strcpy(variable_parts[4], "Miasteczko");
   strcpy(variable_parts[5], "woj. warmińsko-mazurskie");
   strcpy(variable_parts[6], "12-345");

   char letter_template[] = "0 1 2\n3\n4, 5 6\n\nSzanowny(a) 0 2: \n\n"
      "Rodzina 2 może zostać szczęśliwym zwycięzcą w loterii C++.\n"
      "Czy nie byłoby wspaniale, gdyby zostali Państwo jednymi z 4 pierwszych osób\n"
      "używających nowego środowiska programistycznego C++ firmy ACME? itd. itp. \n\n\n";

   vector<char*> fragments = prepare_mailing(letter_template, variable_parts);

   for (int i = 0; i < fragments.size(); i++)
   {
      cout << fragments[i];      
   }
 
   strcpy(variable_parts[0], "Pan");
   strcpy(variable_parts[1], "Henryk");
   strcpy(variable_parts[2], "Morga");
   strcpy(variable_parts[3], "ul. Parkowa 456");
   strcpy(variable_parts[4], "Zwykła Wioska");
   strcpy(variable_parts[5], "woj. lubuskie");
   strcpy(variable_parts[6], "67-890");

   for (int i = 0; i < fragments.size(); i++)
   {
      cout << fragments[i];      
   }

   return 0;
}

