<?php

// Dodaje obsługę miniatur
add_theme_support('post-thumbnails');
set_post_thumbnail_size(540, 300, true);
add_image_size('homepage-thumbnail', 300, 200, true);

// Wyświetla listę stron
function wicked_footer_pagelinks() {
  echo '<ul id="simplepages">';
  wp_list_pages('depth=1&sort_column=menu_order&title_li=');
  echo '</ul>';
}

// Dodaje ikonę Favicon
function wicked_favicon() {
  echo '<link rel="shortcut icon" href="' . get_bloginfo('stylesheet_directory') . '/images/favicon.ico"/>';
}
add_action('wp_head', 'wicked_favicon');

// Dodaje łącza do mediów społecznościowych
function wicked_linklove($content) {
  if(is_single()) {
    $content .= '<div class="linklove">
      Podobał Ci się ten post? Powiedz o tym wszystkim znajomym!
       Tu wklej kod otrzymany w serwisie AddThis.
    </div>';
  }
  return $content;
}
add_filter('thematic_post','wicked_linklove', 90);

// Dodaje dane autora na końcu stron z pojedynczymi postami
function wicked_showbio($content)  {  
  if (is_single()) {  
    $content .=  '<div id="authorbio">';
    $content .= '<h3>About ' . get_the_author() . '</h3>';
    $content .= '<p>' . get_avatar(get_the_author_meta("user_email"), "50");
    $content .= get_the_author_description() .'</p></div>';  
  } 
  return $content;
}
add_filter('thematic_post','wicked_showbio', '70');

// Niestandardowa pętla dla strony głównej
function wicked_indexloop() {
  query_posts("posts_per_page=4");
  $counter = 1;
  if (have_posts()) : while (have_posts()) : the_post(); ?>
    <div id="post-<?php the_ID() ?>" class="<?php thematic_post_class() ?>">
      <?php thematic_postheader();
      if ($counter == 1 && has_post_thumbnail() && !is_paged()) {
        the_post_thumbnail('homepage-thumbnail');
      } ?>
      <div class="entry-content">
        <?php the_excerpt(); ?>
        <a href="<?php the_permalink(); ?>" class="more"><?php echo more_text() ?></a>
        <?php $counter++; ?>
      </div>
    </div><!-- .post -->
  <?php endwhile; else: ?>
    <h2>Eek</h2>
    <p>There are no posts to show!</p>
  <?php endif;
  wp_reset_query();
}

// Zmienia element HTML w tytule widgetów na h4
function wicked_before_title($content) { 
  $content = '<h4 class="widgettitle">'; 
  return $content;
} 
function wicked_after_title($content) {
  $content = '</h4>'; return $content;
} 
add_filter('thematic_before_title', 'wicked_before_title'); 
add_filter('thematic_after_title', 'wicked_after_title');

// Dołącza niestandardowe obszary na widgety
include('library/widget-areas.php');

?>