<?php

// Kilka zmiennych dla panelu opcji
$childthemename = "Wicked Theme";
$childshortname = "wt";
$childoptions = array();

function childtheme_options() {
  global $childthemename, $childshortname, $childoptions;

  // Tworzy tablice do przechowywania kategorii do uzytku w menu rozwijanym
  $categories_obj = get_categories('hide_empty=0');
  $categories = array();
  foreach ($categories_obj as $cat) {
    $categories[$cat->cat_ID] = $cat->cat_name;
  }
  
  $childoptions = array (

    array( "name" => __('Kolor odnosnikw','thematic'),
           "desc" => __('Aby zmienic kolor odnosnikw, wprowadz wartosc koloru w formacie szesnastkowym (e.g.: 003333)','thematic'),
           "id" => "wicked_link_color",
           "std" => "999999",
           "type" => "text"
    ),
    array( "name" => __('Pokaz obraz naglwka','thematic'),
           "desc" => __('Pokazuje obraz w naglwku. Zastap plik header.png w folderze /wicked/images/ wlasnym obrazem o wymiarach nie wiekszych niz 120x100px.','thematic'),
           "id" => "wicked_show_logo",
           "std" => "false",
           "type" => "checkbox"
    ),
    array( "name" => __('Polecana kategoria','thematic'),
           "desc" => __('Kategoria postw, ktre maja byc polecane na stronie glwnej.','thematic'),
           "id" => "wicked_feature_cat",
           "std" => $default_cat,
           "type" => "select",
           "options" => $categories
    )
  );
}
add_action('init', 'childtheme_options');

// Tworzy strone opcji motywu
function childtheme_add_admin() {
  global $childthemename, $childshortname, $childoptions;

  if ( $_GET['page'] == basename(__FILE__) ) {

    if ( 'save' == $_REQUEST['action'] ) {
      // Zabezpieczenie przed sfalszowanymi zadaniami
      check_admin_referer('childtheme-save');
      // Zapisuje opcje
      foreach ($childoptions as $value) {
        if( isset( $_REQUEST[ $value['id'] ] ) ) {
          update_option( $value['id'], $_REQUEST[ $value['id'] ]  );
        } else {
          delete_option( $value['id'] );
        }
      }

      // Powrt do strony opcji
      header("Location: themes.php?page=options.php&saved=true");
      die;

    } else if ( 'reset' == $_REQUEST['action'] ) {
      // Zabezpieczenie przed sfalszowanymi zadaniami
      check_admin_referer('childtheme-reset');
      // Usuwa opcje
      foreach ($childoptions as $value) {
        delete_option( $value['id'] );
      }

      // Powrt do strony opcji
      header("Location: themes.php?page=options.php&reset=true");
      die;
    }
  }
  add_theme_page($childthemename." Options", "$childthemename Options", 'edit_themes', basename(__FILE__), 'childtheme_admin');
}
add_action('admin_menu' , 'childtheme_add_admin');

function childtheme_admin() {

  global $childthemename, $childshortname, $childoptions;

  // Komunikat o zapisaniu lub zaktualizowaniu
  if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$childthemename.' settings saved.</strong></p></div>';
  if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$childthemename.' settings reset.</strong></p></div>';

  // Formularz
  ?>

  <div class="wrap">
  <h2><?php echo $childthemename; ?> Options</h2>

  <form method="post">

  <?php wp_nonce_field('childtheme-save'); ?>
  <table class="form-table">

  <?php foreach ($childoptions as $value) {

    // Generuje odpowiedni element formularza
    switch ( $value['type'] ) {
      
      case 'text':
      ?>
      <tr valign="top">
        <th scope="row"><?php echo $value['name']; ?>:</th>
        <td>
          <input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" value="<?php echo stripslashes(get_option( $value['id'], $value['std'] )); ?>" />
          <?php echo $value['desc']; ?>
        </td>
      </tr>
      <?php
      break;

      case 'select':
      ?>
      <tr valign="top">
        <th scope="row"><?php echo $value['name']; ?></th>
        <td>
          <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
            <option value="">--</option>
            <?php foreach ($value['options'] as $key=>$option) {
              if ($key == get_option($value['id'], $value['std']) ) {
                $selected = "selected=\"selected\"";
              } else {
                $selected = "";
              }
            ?>
            <option value="<?php echo $key ?>" <?php echo $selected ?>><?php echo $option; ?></option>
          <?php } ?>
          </select>
          <?php echo $value['desc']; ?>
        </td>
      </tr>
      <?php
      break;

      case 'textarea':
      $ta_options = $value['options'];
      ?>
      <tr valign="top">
        <th scope="row"><?php echo $value['name']; ?>:</th>
        <td>
          <?php echo $value['desc']; ?>
          <textarea name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" cols="<?php echo $ta_options['cols']; ?>" rows="<?php echo $ta_options['rows']; ?>"><?php
            echo stripslashes(get_option($value['id'], $value['std']));
          ?></textarea>
        </td>
      </tr>
      <?php
      break;

      case "radio":
      ?>
      <tr valign="top">
        <th scope="row"><?php echo $value['name']; ?>:</th>
        <td>
          <?php foreach ($value['options'] as $key=>$option) {
            if ($key == get_option($value['id'], $value['std']) ) {
              $checked = "checked=\"checked\"";
            } else {
              $checked = "";
            }
            ?>
            <input type="radio" name="<?php echo $value['id']; ?>" value="<?php echo $key; ?>" <?php echo $checked; ?> /><?php echo $option; ?><br />
          <?php } ?>
          <?php echo $value['desc']; ?>
        </td>
      </tr>
      <?php
      break;

      case "checkbox":
      ?>
      <tr valign="top">
        <th scope="row"><?php echo $value['name']; ?></th>
        <td>
          <?php
          if(get_option($value['id'])){
            $checked = "checked=\"checked\"";
          } else {
            $checked = "";
          }
          ?>
          <input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
          <?php echo $value['desc']; ?>
        </td>
      </tr>
      <?php
      break;

      default:
      break;
    }
  }
  ?>

  </table>

  <p class="submit">
    <input name="save" type="submit" value="Save changes" class="button-primary" />
    <input type="hidden" name="action" value="save" />
  </p>

  </form>

  <form method="post">
    <?php wp_nonce_field('childtheme-reset'); ?>
    <p class="submit">
      <input name="reset" type="submit" value="Reset" />
      <input type="hidden" name="action" value="reset" />
    </p>
  </form>

  <p><?php _e('Wiecej informacji o tym motywie znajdziesz w ksiazce <a href="http://sitepoint.com/books/wordpress1">Build Your Own Wicked WordPress Themes</a>. Jesli masz jakies pytania, wejdz na <a href="http://sitepoint.com/forums/">SitePoint Forums</a>.', 'thematic'); ?></p>

  <?php
} // Koniec funkcji

?>