﻿<#
   .Synopsis
    Wyświetla informacje o procesorze komputera.
   .Description
    Skrypt ten wyświetla informacje o procesorze lokalnego lub 
    zdalnego komputera. Zwraca następujące informacje: użycie procesora, 
    szybkość procesora, rozmiar bufora L2, liczba rdzeni oraz architektura.
   .Example
    DisplayProcessor.ps1
    Wyświetla informacje o procesorze komputera lokalnego.
   .Example
    DisplayProcessor.ps1 -computer berlin
    Wyświetla informacje o procesorze zdalnego komputera o nazwie berlin.
   .Inputs
    [string]
   .OutPuts
    [string]
   .Notes
    NAZWA:  Windows PowerShell Best Practices
    AUTOR: Ed Wilson
    DATA EDYCJI: 7.9.2013
    WERSJA: 1.0.1
    SŁOWA KLUCZOWE:
   .Link
     Http://www.ScriptingGuys.com
#Requires -Version 2.0
#>
param(
  [Parameter(position=0)]
  [string]
  [alias("CN")]
  $computer=$env:computername
) #end param

# Początek sekcji z funkcjami
function New-Underline
{
<#
.Synopsis
 Tworzy podkreślenie o długości łańcucha wejściowego.
.Example
 New-Underline -strIN "Witaj, świecie"
.Example
 New-Underline -strIn "Morgen welt" -char "-" -sColor "blue" -uColor "yellow"
.Example
 "to jest łańcuch" | New-Underline
.Notes
 NAZWA:
 AUTOR: Ed Wilson
 DATA EDYCJI: 5/20/2009
 WERSJA: 1.0.0
 SŁOWA KLUCZOWE:
.Link
 Http://www.ScriptingGuys.com
#>
[CmdletBinding()]
param(
      [Parameter(Mandatory = $true,Position = 0,valueFromPipeline=$true)]
      [string]
      $strIN,
      [string]
      $char = "=",
      [string]
      $sColor = "Green",
      [string]
      $uColor = "darkGreen",
      [switch]
      $pipe
 ) #end param
 $strLine= $char * $strIn.length
 if(-not $pipe)
  {
   Write-Host -ForegroundColor $sColor $strIN
   Write-Host -ForegroundColor $uColor $strLine
  }
  Else
  {
  $strIn
  $strLine
  }
} #end funkcja New-Underline

Function Get-Processor 
{
 Param ([string]$computer)
 get-wmiobject -class win32_processor -computername $computer |
 foreach-object `
  {
   New-Underline("Dane procesora komputera $computer")
   $_.psobject.properties |
   foreach-object `
    {
     If($_.value)
      {
       if ($_.name -match "__"){}
       ELSE
        {
         $Processor +=@{ $($_.name) = $($_.value) }
        } #end else
      } #end if
    } #end foreach property
    $Processor  ; $Processor.clear()
  } #end foreach Processor
 Return
} #end Get-Processor
# punkt początkowy skryptu

Get-Processor -computer $computer