﻿Param(
  [string]$baseLineScript,
  [string]$modifiedScript,
  [int]$numberOfTests = 20,
  [switch]$log
) #end param

Function Test-Scripts
{
  Param(
  [string]$baseLineScript,
  [string]$modifiedScript,
  [int]$numberOfTests,
  [switch]$log
) #end param
 Measure-Command -Expression { $baseLineScript }
 Measure-Command -Expression { $modifiedScript }
} #end funkcja Test-Scripts

Function Get-Change($baseLine, $modified)
{
  (($baseLine - $modified)/$baseLine)*100
} #end funkcja Get-Change

Function Get-TempFile
{
 [io.path]::GetTempFileName()
} #end funkcja Get-TempFile

# *** punkt początkowy skryptu ***
if($log) { $logFile = Get-TempFile }
For($i = 0 ; $i -le $numberOfTests ; $i++)
{
 "Test $i z $numberOfTests" ; start-sleep -m 50 ; cls
 $results= Test-Scripts -baseLineScript $baseLineScript -modifiedScript $modifedScript
 $baseLine += $results[0].TotalSeconds
 $modified += $results[1].TotalSeconds
 If($log)
  {
     "Skrypt {$baseLineScript}: test $i z $numberOfTests $(get-date)" >> $logFile
     $results[0] >> $logFile
     "Skrypt {$modifiedScript}: test $i z $numberOfTests $(get-date)" >> $logFile
     $results[1] >> $logFile
  } #if $log
} #for $i 

"Średnia zmiana dla $numberOfTests testów"
"Średnia liczba sekund wykonywania skryptu {$baseLineScript}: $($baseLine/$numberOfTests)"
"Średnia liczba sekund wykonywania skryptu {$modifiedScript}: $($modified/$numberOfTests)"
"Zmiana procentowa: " + "{0:N2}" -f (Get-Change -baseLine $baseLine -modified $modified)
if($log)
{
 "Średnia zmiana dla $numberOfTests testów" >> $logFile
 "Średnia liczba sekund wykonywania skryptu {$baseLineScript}: $($baseLine/$numberOfTests)" >> $logFile
 "Średnia liczba sekund wykonywania skryptu {$modifiedScript}: $($modified/$numberOfTests)" >> $logFile
 "Zmiana procentowa: " + "{0:N2}" -f (Get-Change -baseLine $baseLine -modified $modified) >> $logFile
} #if $log
if($log) { Notepad $logFile }