﻿Param([switch]$trace = $true)
$errorActionPreference = "SilentlyContinue"
$error.Clear()
$startTime = $endTime = $null

$logDir = "c:\fso"
if(-not(Test-Path -path $logdir)) 
  { New-Item -Path $logdir -ItemType directory | Out-Null }
$traceLog = Join-Path -Path $logDir -ChildPath "Tracelog.txt"
$startTime = (Get-Date).tostring()

If($trace) 
  {"**Początek wykonywania skryptu: $($MyInvocation.InvocationName) $startTime" >> $traceLog} 
If($trace) 
  {"Tworzenie obiektu msgraph.application" >> $traceLog} 
$chart = New-Object -ComObject msgraph.application
$chart.visible = $true
If($trace) 
  {"Dodawanie podpisów kolumn wykresu" >> $traceLog} 
$chart.datasheet.cells.item(1,1) = "Nazwa procesu"
$chart.datasheet.cells.item(1,2) = "Zbiór roboczy"
If($trace) 
  {"Dodawanie danych do wykresu" >> $traceLog}
$r = 2
If($trace) 
  {"Pobieranie informacji procesu" >> $traceLog} 
  
Get-Process | 
ForEach-Object {
  $chart.datasheet.cells.item($r,1) = $_.name
  $chart.datasheet.cells.item($r,2) = $_.workingSet
  $r++
} #end foreach process

$endTime = (Get-Date).tostring()
If($trace) 
  {"**Koniec wykonywania skryptu: $endTime. " >> $traceLog}
If($trace) 
  {"**Czas działania skryptu w sekundach: $((New-TimeSpan -Start $startTime `
  -End $endTime).totalSeconds) `r`n" >> $traceLog}
"*** Liczba błędów: $($error.count) ***" >> $traceLog
 Foreach ($e in $error) { $e >> $tracelog }