﻿
function get-ScriptVersion ([string]$path)
{
 $scripts = Get-ChildItem -Path $path -recurse
 ForEach($script in $scripts)
 { 
  $info = New-Object psobject
  $scriptText = Get-Content $script.fullname 
  $info | 
  Add-Member -Name "name" -Value $script.name -MemberType noteproperty
  $lastedit = $scriptText | 
  Select-String -Pattern "\s\d{1,1}/\d{1,2}/\d{1,4}"
  
  if($lastedit.count -gt 1)
   {
     $info | 
     Add-Member -Name "LastEdit" -Value $lastedit[0].matches[0].value `
     -membertype noteproperty
   }
  if($lastedit.matches.count -gt 0)
   { 
    $info | 
    Add-Member -Name "LastEdit" -Value $lastedit.matches[0].value `
    -membertype noteproperty -Force
   }
  $version =  $scriptText | 
  Select-String -Pattern "\s\d\.\d\.\d"
  
  if($version.count -gt 1)
   {
    $info | 
    Add-Member -Name version -Value $version[0].matches[0].value `
    -membertype noteproperty -Force
   }
  if($version.matches.count -gt 0)
   {
    $info | 
    Add-Member -Name version -Value $version.matches[0].value `
    -membertype noteproperty -Force
   }
  $info 
  $version = $lastedit = $scriptText = $null
 } #end foreach
} #end funkcja get-ScriptVersion

# *** punkt początkowy skryptu ***

Get-ScriptVersion -path C:\data\BookDOcs\PS4_BestPractices\Scripts | 
Format-Table -Property * -AutoSize -Wrap