﻿if((Get-WmiObject win32_computersystem).model -ne "virtual machine")
  {
    $response = Read-Host -prompt "Ten skrypt najlepiej jest uruchamiać w maszynie wirtualnej. 
    Czy chcesz kontynuować? <t / n>"
    if ($response -eq "n") { exit }
  }
$path = "C:\ScriptFolder"
$report = [io.path]::GetTempFileName()
Get-ChildItem -Path $path -Include *.ps1 -Recurse |
ForEach-Object -Begin `
  { 
   $stime = Get-Date
   $ErrorActionPreference = "SilentlyContinue" 
   "Testowanie skryptów w folderze $path $stime" | 
     Out-File -append -FilePath $report
  } -Process `
  {
   $error.Clear() 
   $startTime = Get-Date
   "  Początek testowania skryptu $_ o godzinie $startTime" | 
     Out-File -append -FilePath $report
   Invoke-Expression -Command $_ 
   $endTime = Get-Date
   "  Testowanie skryptu $_ zakończono o godzinie $endTime." | 
     Out-File -append -FilePath $report
   "    Liczba błędów wygenerowanych przez skrypt: $($error.Count)" | 
     Out-File -append -FilePath $report
   "    Czas testowania tego skryptu: $($endTime - $startTime)" |
     Out-File -append -FilePath $report
  } -end `
  { 
   $etime = Get-Date
   $ErrorActionPreference = "Continue"
   "Zakończono testowanie wszystkich skryptów z folderu $path $etime" | 
     Out-File -append -FilePath $report
   " Czas trwania testu: $($etime - $stime)" | 
     Out-File -append -FilePath $report
  }
  
  Notepad $report