﻿# ------------------------------------------------------------------------
# NAZWA: BackUpFiles.ps1
# AUTOR: ed wilson, Microsoft
# DATA: 12.12.2008
#
# SŁOWA KLUCZOWE: system plików, get-childitem, where-object
# używanie daty, wyrażenia regularne
#
# UWAGI: Skrypt ten tworzy kopię zapasową folderu. Kopiuje
# pliki, które zostały zmienione w ciągu ostatnich 24 godzin. 
# Można zmienić częstotliwość kopiowania plików, miejsce ich 
# zapisu oraz źródło. Skrypt tworzy folder o nazwie utworzonej z
# godziny, o której został uruchomiony. Jeśli folder docelowy nie
# istnieje, zostanie utworzony. Nazwa folderu jest tworzona na podstawie
# czasu uruchomienia skryptu i wygląda tak: C:\bu\12.12.2008.1.22.51.PM.
# Odstęp czasu oznacza wiek w dniach plików do skopiowania.
#
# ---------------------------------------------------------------------
Function New-BackUpFolder($destinationFolder)
{
 # Pobiera ścieżkę do folderu docelowego i tworzy ścieżkę do
 # folderu potomnego na podstawie daty i godziny. Następnie wywołuje
 # funkcję New-Backup, przekazując ścieżkę źródłową, ścieżkę docelową i
 # odstęp czasu w dniach. 
 $dte = get-date
 # Poniższe wyrażenie regularne usuwa białe znaki, średniki,
 # i ukośniki / z daty oraz zamienia je na kropki, tworząc w ten
 # sposób nazwę folderu na kopię zapasową. 
 $dte = $dte.tostring() -replace "[:\s/]", "."
 $backUpPath = "$destinationFolder" + $dte
 $null = New-Item -path $backUpPath -itemType directory
 New-Backup $dataFolder $backUpPath $backUpInterval
} #end New-BackUpFolder

Function New-Backup($dataFolder,$backUpPath,$backUpInterval)
{
 # Rekurencyjnie kopiuje wszystkie pliki znajdujące się w folderze danych i
 # odfiltrowuje wszystkie pliki, które zmieniły się w ciągu określonej liczby dni.
 # Zapisuje skopiowane pliki do folderu docelowego i tworzy go (wliczając ścieżkę nadrzędną),
 # jeśli nie istnieje. Jeśli dany folderu już istnieje, zostanie nadpisany. Jest to jednak 
 # mało prawdopodobne, chyba że skrypt zostanie uruchomiony dwa razy w jednej minucie. 
 "Kopiowanie plików z folderu $dataFolder... Pliki powinny znajdować się w folderze $backUppath."
 Get-Childitem -path $dataFolder -recurse |
 Where-Object { $_.LastWriteTime -ge (get-date).addDays(-$backUpInterval) } |
 Foreach-Object { copy-item -path $_.FullName -destination $backUpPath -force }
} #end New-BackUp

# *** punkt początkowy skryptu ***

$backUpInterval = 1
$dataFolder = "C:\fso"
$destinationFolder = "C:\BU\"
New-BackupFolder $destinationFolder