﻿# *** funkcje ***
Function Set-Profile()
{
 Notepad $profile
 # Funkcja Pana Eda
}

Function Get-MoreHelp()
{
 #.Help Get-MoreHelp Get-Command
 Get-Help $args[0] -Full | 
 more
  #MrEd function
} #end Get-MoreHelp

Function Get-WmiClass([string]$ns, [string]$class)
{
 #.Help Get-WmiClass -ns "root\cimv2" -class "Processor"
 $ns = $args[0]
 $class = $args[1]
 Get-WmiObject -List -Namespace $ns |
 Where-Object { $_.name -match $class }
  #MrEd function
} #end Get-WmiClass

# *** aliasy ***

New-Alias -Name mo -Value Measure-Object -Option allscope `
  -Description "Alias Pana Eda"
New-Alias -name gmh -value Get-MoreHelp -Option allscope `
  -Description "Alias Pana Eda"
New-Alias -Name gwc -Value Get-WmiClass -Option readonly,allscope `
  -Description "Alias Pana Eda"

# *** zmienne ***

New-Variable -Name wulog -Value (Join-Path -Path $env:LOCALAPPDATA `
  -ChildPath microsoft\windows\windowsupdate.log -Resolve) `
  -Option readonly -Description "Zmienna Pana Eda"
New-Variable -Name docs -Value (Join-Path -Path $home -ChildPath documents) `
  -Option readonly -Description "Zmienna Pana Eda"
New-Variable -name wshShell -value (New-Object -ComObject Wscript.Shell) `
  -Option readonly -Description "Zmienna Pana Eda"

# *** dyski PowerShell ***

New-PSDrive -Name HKCR -PSProvider registry -Root Hkey_Classes_Root `
  -Description "Dysk Pana Eda" | out-null
