﻿# Odczytuje dane kanałów z bloga programistów PowerShell
$feeds = Invoke-RestMethod http://blogs.msdn.com/b/powershell/atom.aspx

# Filtruje i formatuje wyniki.
$feeds | ForEach {
    [PSCustomObject]@{
        Title=$_.title;
        Author=$_.author.name;
        Link=$_.link.href;
        Date=[DateTime]$_.published
     }
} | ConvertTo-Json
