﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Management.Automation;
using System.Text.RegularExpressions;

namespace MyBinaryModule
{
    
    // parzysta czy nieparzysta
    [Cmdlet(VerbsCommon.Get,"EvenOrOdd")]
    public class EvenorOdd : Cmdlet
    {
        [Parameter(Position = 0,
           ValueFromPipeline = true,
           ValueFromPipelineByPropertyName = true,
           HelpMessage = @"Zakres liczb do sprawdzenia")]
        public int[] Numbers
        {
            get { return num; }
            set { num = value; }
        }
        private int[] num;

        protected override void ProcessRecord()
        {
            base.ProcessRecord();

            foreach (int i in Numbers)
            {
                if ((i % 2) != 0)
                    WriteObject(i.ToString() + " to liczba nieparzysta");
                else
                    WriteObject(i.ToString() + " to liczba parzysta");
            }

        }
    }
    
    // Sprawdza adres e-mail przy użyciu wyrażenia regularnego.
    [Cmdlet("Validate", "EmailAddress")]
    public class ValidateEmailAddress : Cmdlet
    {
        [Parameter(Position = 0,
           ValueFromPipeline = true,
           ValueFromPipelineByPropertyName = true,
           HelpMessage = @"Adres e-mail do sprawdzenia")]
        public string EmailAddress
        {
            get { return Email; }
            set { Email = value; }
        }
        private string Email;

        protected override void ProcessRecord()
        {
            base.ProcessRecord();

            // Wyświetla rozszerzone informacje przy użyciu parametru -Verbose.
            WriteVerbose("Validating Email Address: " + EmailAddress);

            // Wyświetla rozszerzone informacje przy użyciu parametru -Debug.
            WriteDebug("Validating Email Address: " + EmailAddress);

            Regex reg = new Regex(@"(\w+@[a-zA-Z_-]+?\.[a-zA-Z_-]{2,6})");
            
            // Zapisuje informacje obiektu do wyświetlenia jako wynik wykonania polecenia.
            WriteObject(reg.IsMatch(EmailAddress));  
        }
    }


}
