﻿using System;
using System.Windows;
using System.Windows.Media;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Tasks;

namespace MediaPlayerDemo
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Zmienna _updatingMediaTimeline jest niezbędna, aby 
        // zabezpieczyć aplikację przed 
        // przewinięciem filmu w przód lub wstecz 
        // w chwili, gdy oś czasu jest odświeżana.
        private bool _updatingMediaTimeline;

        public MainPage()
        {
            InitializeComponent();

            _updatingMediaTimeline = false;

            
            mediaPlayer.Source = new Uri(txtUrl.Text);

            // Przewinicie filmu na początek
            mediaPlayer.Position = System.TimeSpan.FromSeconds(0);

            // Wskaźnik postępu pobierania
            mediaPlayer.DownloadProgressChanged += (s, e) =>
                {
                    lblDownload.Text = string.Format("Pobieranie {0:0.0%}", mediaPlayer.DownloadProgress);
                };

            // Obsługa buforowania
            mediaPlayer.BufferingTime = TimeSpan.FromSeconds(Convert.ToDouble(txtBufferingTime.Text));
            mediaPlayer.BufferingProgressChanged += (s, e) =>
                {
                    lblBuffering.Text = string.Format("Buforowanie {0:0.0%}", mediaPlayer.BufferingProgress);
                };

            // Uaktualnienie osi czasu (kontrolki Slider) zgodnie z bieżącą wartością czasu
            // odtwarzania i odświeżenie pola informacji statusowych
            CompositionTarget.Rendering += (s, e) =>
                {
                    _updatingMediaTimeline = true;
                    TimeSpan duration = mediaPlayer.NaturalDuration.TimeSpan;
                    if (duration.TotalSeconds != 0)
                    {
                        double percentComplete = mediaPlayer.Position.TotalSeconds / duration.TotalSeconds;
                        mediaTimeline.Value = percentComplete;
                        TimeSpan mediaTime = mediaPlayer.Position;
                        string text = string.Format("{0:00}:{1:00}", 
                            (mediaTime.Hours * 60) + mediaTime.Minutes, mediaTime.Seconds);

                        if (lblStatus.Text != text)
                            lblStatus.Text = text;

                        _updatingMediaTimeline = false;
                    }
                };
        }

        private void btnPause_Click(object sender, RoutedEventArgs e)
        {
            if (mediaPlayer.CanPause)
            {
                mediaPlayer.Pause();
                lblStatus.Text = "Wstrzymane";
            }
            else
            {
                lblStatus.Text = "Nie można wstrzymać odtwarzania. Spróbuj ponownie!";
            }
        }

        private void btnStop_Click(object sender, RoutedEventArgs e)
        {
            mediaPlayer.Stop();
            mediaPlayer.Position = System.TimeSpan.FromSeconds(0);
            lblStatus.Text = "Zatrzymane";
        }

        private void btnPlay_Click(object sender, RoutedEventArgs e)
        {
            mediaPlayer.Play();
        }

        private void btnMute_Click(object sender, RoutedEventArgs e)
        {
            if (lblSoundStatus.Text.Equals("Głos włącz.", StringComparison.CurrentCultureIgnoreCase))
            {
                lblSoundStatus.Text = "Głos wyłącz.";
                mediaPlayer.IsMuted = true;
            }
            else
            {
                lblSoundStatus.Text = "Głos włącz.";
                mediaPlayer.IsMuted = false;
            }
            
        }

        private void mediaTimeline_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            if (!_updatingMediaTimeline && mediaPlayer.CanSeek)
            {
                TimeSpan duration = mediaPlayer.NaturalDuration.TimeSpan;
                int newPosition = (int)(duration.TotalSeconds * mediaTimeline.Value);
                mediaPlayer.Position = new TimeSpan(0, 0, newPosition);
            }
        }

        private void btnMediaPlayerLauncher_Click(object sender, RoutedEventArgs e)
        {
            MediaPlayerLauncher player = new MediaPlayerLauncher();
            player.Media = new Uri(txtUrl.Text);
            player.Show();
        }
    }
}


//player.Media = new Uri("ARCastMDISilverlightGridComputing_ch9.wmv", UriKind.Relative);
//player.Location = MediaLocationType.Install;
