﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Notification;
using System.Diagnostics;

namespace PNClient
{
    public partial class MainPage : PhoneApplicationPage
    {
        Uri channelUri;

        public Uri ChannelUri
        {
            get { return channelUri; }
            set
            {
                channelUri = value;
                OnChannelUriChanged(value);
            }
        }

        private void OnChannelUriChanged(Uri value)
        {
            Dispatcher.BeginInvoke(() =>
            {
                txtURI.Text = "zmiana URI na " + value.ToString();
            });

            Debug.WriteLine("zmiana URI na " + value.ToString());
        }

        public MainPage()
        {
            InitializeComponent();            
        }

        private void btnCreateChannel_Click(object sender, RoutedEventArgs e)
        {
            SetupChannel();
        }

        private void SetupChannel()
        {
            HttpNotificationChannel httpChannel = null;
            string channelName = "DemoChannel";

            try
            {
                //Pobranie informacji o istniejącym kanale, jeśli takowy istnieje.
                httpChannel = HttpNotificationChannel.Find(channelName);
                if (httpChannel != null)
                {
                    //Jeśli przejęcie kanału jest niemożliwe, należy go zamknąć i ustanowić ponownie.
                    if (httpChannel.ChannelUri == null)
                    {
                        httpChannel.UnbindToShellToast();
                        httpChannel.Close();
                        SetupChannel();
                        return;
                    }
                    else
                    {
                        ChannelUri = httpChannel.ChannelUri;
                        txtURI.Text = "Kanał utworzony: " + httpChannel.ChannelUri;
                        //Dowiązanie procedury obsługi niesformatowanych powiadomień
                        httpChannel.HttpNotificationReceived += new EventHandler<HttpNotificationEventArgs>(httpChannel_HttpNotificationReceived);
                    }
                }
                else
                {
                    httpChannel = new HttpNotificationChannel(channelName);
                    httpChannel.ChannelUriUpdated += new EventHandler<NotificationChannelUriEventArgs>(httpChannel_ChannelUriUpdated);
                    httpChannel.ErrorOccurred += new EventHandler<NotificationChannelErrorEventArgs>(httpChannel_ExceptionOccurred);

                    //Dowiązanie procedury obsługi niesformatowanych powiadomień
                    httpChannel.HttpNotificationReceived += new EventHandler<HttpNotificationEventArgs>(httpChannel_HttpNotificationReceived);

                    httpChannel.Open();
                }
            }
            catch (Exception ex)
            {

            }
        }

        void httpChannel_ExceptionOccurred(object sender, NotificationChannelErrorEventArgs e)
        {
            //Wyświetlenie komunikatu o błędzie
            Debug.WriteLine ( e.Message);
        }

        void httpChannel_ChannelUriUpdated(object sender, NotificationChannelUriEventArgs e)
        {
            //Pobranie nowego (lub zaktualizowanego) identyfikatora URI
            ChannelUri = e.ChannelUri;
        }

        // Pobranie niesformatowanego powiadomienia
        // Niesformatowane powiadomienia są dostarczane do aplikacji tylko wtedy, gdy pracuje jako proces pierwszoplanowy.
        // Jeśli aplikacja nie pracuje na pierwszym planie, powiadomienie jest ignorowane.
        void httpChannel_HttpNotificationReceived(object sender, HttpNotificationEventArgs e)
        {
            if (e.Notification.Body != null && e.Notification.Headers != null)
            {
                System.IO.StreamReader reader = new System.IO.StreamReader(e.Notification.Body);
                Dispatcher.BeginInvoke(() =>
                {
                    txtURI.Text = "Odebrane niesformatowane powiadomienie: " + reader.ReadToEnd();
                });
            }
        }
    }
}
