﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.Data.Entity;

namespace MvcWebRole1.Models
{
    public class ZdjecieDBContext : DbContext
    {
        public DbSet<Zdjecie> ZbiorZdjec { get; set; }
    }

    public class Zdjecie
    {
        //unikatowy identyfikator zdjęcia
        [Key]
        public int ID { get; set; }

        //GUID użytkownika, który dodał zdjęcie
        public Guid UserId { get; set; }

        //tytuł zdjęcia
        [Required(ErrorMessage = "Pole Tytuł nie może być puste!")]
        [Display(Name = "Tytuł")]
        public string Tytul { get; set; }


        //data opublikowania zdjęcia
        [Required(ErrorMessage = "Pole DataOpublikowania  Data opublikowania nie może być puste!")]
        [Display(Name = "Data opublikowania")]
        public DateTime DataOpublikowania { get; set; }

        //kategoria zdjęcia
        [Required(ErrorMessage = "Pole Kategoria nie może być puste!")]
        [StringLength(25, MinimumLength = 3, ErrorMessage = "Nazwa kategorii musi składać się z minimum 3 i maksimum 25 znaków")]
        public string Kategoria { get; set; }

        //cena zdjęcia
        [Required(ErrorMessage = "Pole Cena nie może być puste!")]
        [Range(0.0, 1000.00, ErrorMessage = "Cena musi być w zakresie od 0 do 1000 zł")]
        [DisplayFormat(DataFormatString = "{0:C}", ApplyFormatInEditMode = true)]
        public decimal Cena { get; set; }

        //odsyłacz do zdjęcia przechowywanego w Azure Blobs
        [Display(Name = "Obrazek")]
        public string Link { get; set; }
    }

}