﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PersonalInformationClients.BenchmarkClient.PersonalInformationServiceReference;
using System.ServiceModel;

namespace PersonalInformationClients.BenchmarkClient
{
    class Program
    {
        private static int milicesonds = 10000;

        static void Main(string[] args)
        {
            Console.WriteLine("Press enter to start tests");
            Console.ReadLine();

            ReferenceTest();
            //ChannelFactoryTest();

            Console.WriteLine("Press enter to close");
            Console.ReadLine();
        }

        private static void ReferenceTest()
        {
            RunSingleReferenceTest("BasicHttpBinding_IPersonalInformationService");

            RunSingleReferenceTest("WSHttpBinding_IPersonalInformationService");
            RunSingleReferenceTest("WSHttpBindingNoSec_IPersonalInformationService");

            RunSingleReferenceTest("NetTcpBinding_IPersonalInformationService");
            RunSingleReferenceTest("NetTcpBindingNoSec_IPersonalInformationService");
            RunSingleReferenceTest("NetNamedPipeBinding_IPersonalInformationService");
            RunSingleReferenceTest("NetNamedPipeBindingNoSec_IPersonalInformationService");
        }

        private static void RunSingleReferenceTest(string endpointName)
        {
            try
            {
                Console.WriteLine("Service reference {0} test", endpointName);
                using (PersonalInformationServiceClient client = new PersonalInformationServiceClient(endpointName))
                {
                    client.Open();

                    DateTime startDate = DateTime.Now;
                    int count = 0;

                    PersonalInformationRequest request = new PersonalInformationRequest() { PersonId = 1 };
                    

                    while (DateTime.Now.Subtract(startDate).TotalMilliseconds < milicesonds)
                    {
                        client.GetPersonalInformation(request);
                        count++;
                    }

                    Console.WriteLine("{0} requests in {1} ms", count, milicesonds);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
        }

        private static void ChannelFactoryTest()
        {
            RunSingleChannelFactoryTest("BasicHttpBinding_IPersonalInformationService");

            RunSingleChannelFactoryTest("WSHttpBinding_IPersonalInformationService");
            RunSingleChannelFactoryTest("WSHttpBindingNoSec_IPersonalInformationService");

            RunSingleChannelFactoryTest("NetTcpBinding_IPersonalInformationService");
            RunSingleChannelFactoryTest("NetTcpBindingNoSec_IPersonalInformationService");
            RunSingleChannelFactoryTest("NetNamedPipeBinding_IPersonalInformationService");
            RunSingleChannelFactoryTest("NetNamedPipeBindingNoSec_IPersonalInformationService");
        }

        private static void RunSingleChannelFactoryTest(string endpointName)
        {
            try
            {
                Console.WriteLine("Channel factory {0} test", endpointName);
                ChannelFactory<IPersonalInformationService> factory =
                    new ChannelFactory<IPersonalInformationService>(endpointName);

                IPersonalInformationService proxy = factory.CreateChannel();
                PersonalInformationRequest request = new PersonalInformationRequest() { PersonId = 1 };

                DateTime startDate = DateTime.Now;
                int count = 0;

                while (DateTime.Now.Subtract(startDate).TotalMilliseconds < milicesonds)
                {
                    proxy.GetPersonalInformation(request);
                    count++;
                }

                Console.WriteLine("{0} requests in {1} ms", count, milicesonds);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
        }
    }
}
