﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PersonalInformationClients.ServiceReferenceClient.PersonalInformationServiceReference;
using System.Configuration;

namespace PersonalInformationClients.ServiceReferenceClient
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Press [ENTER] to call PersonalInformationService");
            Console.ReadLine();

            CallService();

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }

        private static void CallService()
        {
            string selectedEndpoint = ConfigurationManager.AppSettings["SelectedEndpointName"];
            Console.WriteLine("Call service using {0}", selectedEndpoint);
            using (PersonalInformationServiceClient client =
                            new PersonalInformationServiceClient(selectedEndpoint))
            {
                try
                {
                    var response = client.GetPersonalInformation(
                        new PersonalInformationRequest()
                        {
                            PersonId = 1
                        });

                    PrintResponse(response);
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                }
            }
        }

        private static void PrintResponse(PersonalInformationResponse response)
        {
            Console.WriteLine("Received response");
            foreach (var person in response.Persons)
            {
                Console.WriteLine("{0} : {1} {2}", person.Id, person.Name, person.Surname);
            }
        }
    }
}
