﻿using System;
using System.Collections.Generic;
using System.ServiceModel;
using PersonalInformationService.ServiceContracts;

namespace PersonalInformationClients.ChannelFactoryClient
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Press [ENTER] to call PersonalInformationService");
            Console.ReadLine();

            Uri baseAddr = new Uri("http://localhost:9000/PersonalInformationService.svc/");

            ChannelFactory<IPersonalInformationService> factory = 
                new ChannelFactory<IPersonalInformationService>(new WSHttpBinding(), new EndpointAddress(baseAddr));

            IPersonalInformationService proxy = factory.CreateChannel();
            var response = proxy.GetPersonalInformation(
                new PersonalInformationService.Messages.PersonalInformationRequest()
                {
                    PersonId = 1
                });
            
            Console.WriteLine("Received response");
            foreach (var person in response.Persons)
            {
                Console.WriteLine("{0} : {1} {2}", person.Id, person.Name, person.Surname);
            }

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }
    }
}
