﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using CallbackDemoService;

namespace CallbackDemoClient
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("CallbackDemoClient is starting.");
            Console.WriteLine("Press enter to call service");
            Console.ReadLine();

            SampleContractCallback callback = new SampleContractCallback();

            DuplexChannelFactory<ISampleContract> serviceFactory =
                new DuplexChannelFactory<ISampleContract>(
                     callback,
                     new NetTcpBinding(),
                     new EndpointAddress(
                        "net.tcp://localhost:9002/SampleContract"));

            ISampleContract service = serviceFactory.CreateChannel();
            string result = service.GetData(10);
            Console.WriteLine("Result {0}", result);

            Console.WriteLine("Press enter to close");
            Console.ReadLine();
        }
    }
}
