﻿using System;
using System.ServiceModel;
using PersonalInformationService.ServiceImplementations;
using System.ServiceModel.Description;
using PersonalInformationService.ServiceContracts;

namespace PersonalInformationHosts.SelfHost
{
    class Program
    {
        static void Main(string[] args)
        {
            //RunHost();
            RunInlineConfiguredHost();
        }

        private static void RunHost()
        {
            using (ServiceHost host =
               new ServiceHost(typeof(SimplePersonalInformationService)))
            {
                Console.WriteLine("Personal Information Service host starting");
                host.Open();
                Console.WriteLine("Press [ENTER] to stop service...");
                Console.ReadLine();
            }
        }

        private static void RunInlineConfiguredHost()
        {
            //Uri baseAddr = new Uri("http://localhost:8732/Design_Time_Addresses/PersonalInformationService/SimplePersonalInformationService/");
            Uri baseAddr = new Uri("http://localhost:9000/PersonalInformationService/");
            using (ServiceHost host = new ServiceHost(typeof(SimplePersonalInformationService), baseAddr))
            {
                //Add Endpoint
                host.AddServiceEndpoint(typeof(IPersonalInformationService), new BasicHttpBinding(), baseAddr);
                
                //Enable MEX
                ServiceMetadataBehavior smb = new ServiceMetadataBehavior();
                //smb.HttpGetEnabled = true;
                host.Description.Behaviors.Add(smb);
                host.AddServiceEndpoint(new ServiceMetadataEndpoint(new EndpointAddress(baseAddr.AbsoluteUri+"mex")));

                Console.WriteLine("Personal Information Service host with inline configuration is starting");
                //run host
                host.Open();
                Console.WriteLine("Press [ENTER] to stop service...");
                Console.ReadLine();
            }
        }
    }
}