﻿
namespace RIAPoweredSilverlightApplication.Web.Services
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.Data;
    using System.Linq;
    using System.ServiceModel.DomainServices.EntityFramework;
    using System.ServiceModel.DomainServices.Hosting;
    using System.ServiceModel.DomainServices.Server;
    using RIAPoweredSilverlightApplication.Web.Model;


    // Implements application logic using the AdventureWorksEntities context.
    // TODO: Add your application logic to these methods or in additional methods.
    // TODO: Wire up authentication (Windows/ASP.NET Forms) and uncomment the following to disable anonymous access
    // Also consider adding roles to restrict access as appropriate.
    // [RequiresAuthentication]
    [EnableClientAccess()]
    public class AdventureWorksDomainService : LinqToEntitiesDomainService<AdventureWorksEntities>
    {

        // TODO:
        // Consider constraining the results of your query method.  If you need additional input you can
        // add parameters to this method or create additional query methods with different names.
        // To support paging you will need to add ordering to the 'Product' query.
        public IQueryable<Product> GetProduct()
        {
            return this.ObjectContext.Product;
        }

        // TODO:
        // Consider constraining the results of your query method.  If you need additional input you can
        // add parameters to this method or create additional query methods with different names.
        // To support paging you will need to add ordering to the 'ProductCategory' query.
        public IQueryable<ProductCategory> GetProductCategory()
        {
            return this.ObjectContext.ProductCategory;
        }

        public void InsertProductCategory(ProductCategory productCategory)
        {
            if ((productCategory.EntityState != EntityState.Detached))
            {
                this.ObjectContext.ObjectStateManager.ChangeObjectState(productCategory, EntityState.Added);
            }
            else
            {
                this.ObjectContext.ProductCategory.AddObject(productCategory);
            }
        }

        public void UpdateProductCategory(ProductCategory currentProductCategory)
        {
            this.ObjectContext.ProductCategory.AttachAsModified(currentProductCategory, this.ChangeSet.GetOriginal(currentProductCategory));
        }

        public void DeleteProductCategory(ProductCategory productCategory)
        {
            if ((productCategory.EntityState != EntityState.Detached))
            {
                this.ObjectContext.ObjectStateManager.ChangeObjectState(productCategory, EntityState.Deleted);
            }
            else
            {
                this.ObjectContext.ProductCategory.Attach(productCategory);
                this.ObjectContext.ProductCategory.DeleteObject(productCategory);
            }
        }
    }
}


