﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


using System.ServiceModel;
using System.ServiceModel.Routing;
using System.ServiceModel.Description;

namespace SampleRoutingService
{
    class Program
    {
        static void Main(string[] args)
        {
            using (ServiceHost host = new ServiceHost(typeof(RoutingService)))
            {
                try
                {
                    Console.WriteLine("RoutingService is starting");
                    host.Open();
                    foreach (ServiceEndpoint se in host.Description.Endpoints)
                    {
                        Console.WriteLine("\nAddress: {0}, \n\tBinding: {1}, \n\tContract: {2}", se.Address, se.Binding.Name, se.Contract.Name);
                    }

                    Console.WriteLine("RoutingService started");
                    Console.WriteLine("Press enter to close");
                    Console.ReadLine();
                    host.Close();
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                    Console.ReadLine();
                }
            }
        }
    }
}
