﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PersonalInformationClients.ServiceReferenceClient.PersonalInformationServiceReference;
using System.Configuration;
using System.ServiceModel;
using System.ServiceModel.Channels;

namespace PersonalInformationClients.ServiceReferenceClient
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Press [ENTER] to call PersonalInformationService");
            Console.ReadLine();

            //CallSync();
            //CallAsync();
            //CallWithLargeMessage();
            //CallWithCredentials();

            CallService();

            Console.WriteLine("Press [ENTER] to close client");
            Console.ReadLine();
        }

        #region Async
        private static void CallAsync()
        {
            using (PersonalInformationServiceClient client =
                new PersonalInformationServiceClient("WSHttpBinding_IPersonalInformationService"))
            {
                try
                {
                    client.GetPersonalInformationCompleted += new EventHandler<GetPersonalInformationCompletedEventArgs>(client_GetPersonalInformationCompleted);
                    client.GetPersonalInformationAsync(
                        new PersonalInformationRequest()
                        {
                            PersonId = 1
                        });
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                }
            }
        }

        static void client_GetPersonalInformationCompleted(object sender, GetPersonalInformationCompletedEventArgs e)
        {
            if (e.Error == null)
            {
                PrintResponse(e.Result);
            }
            else
            {
                Console.WriteLine("Async request exception");
                Console.WriteLine(e.Error);
            }
        } 
        #endregion

        private static void CallSync()
        {
            using (PersonalInformationServiceClient client =
                new PersonalInformationServiceClient("WSHttpBinding_IPersonalInformationService"))
            {
                try
                {
                    var response = client.GetPersonalInformation(
                        new PersonalInformationRequest()
                        {
                            PersonId = 1
                        });

                    PrintResponse(response);
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                }
            }
        }


        private static void CallWithLargeMessage()
        {
            using (PersonalInformationServiceClient client =
                new PersonalInformationServiceClient("WSHttpBinding_IPersonalInformationService"))
            {
                try
                {
                    StringBuilder descriptionSb = new StringBuilder();
                    //for (int i = 0; i < 819; i++)
                    for (int i = 0; i < 800; i++)
                    {
                        descriptionSb.Append("1234567890");
                    }

                    //descriptionSb.Append("12");

                    var response = client.GetPersonalInformation(
                        new PersonalInformationRequest()
                        {
                            PersonId = 1,
                            Description = descriptionSb.ToString()
                        });

                    PrintResponse(response);
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                }
            }
        }

        private static void CallWithCredentials()
        {
            using (PersonalInformationServiceClient client =
                new PersonalInformationServiceClient("WSHttpBinding_IPersonalInformationService"))
            {
                try
                {
                    //if you are using UserName credentials type
                    //client.ClientCredentials.UserName.UserName = "sampleUserName";
                    //client.ClientCredentials.UserName.Password = "p@ssw0rd";
                    var response = client.GetPersonalInformation(
                        new PersonalInformationRequest()
                        {
                            PersonId = 1,
                            Description = "1234567890"
                        });

                    PrintResponse(response);
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                }
            }
        }

        private static void CallService()
        {
            string selectedEndpoint = ConfigurationManager.AppSettings["SelectedEndpointName"];
            Console.WriteLine("Call service using {0}", selectedEndpoint);
            using (PersonalInformationServiceClient client =
                            new PersonalInformationServiceClient(selectedEndpoint))
            {
                try
                {
                    var response = client.GetPersonalInformation(
                        new PersonalInformationRequest()
                        {
                            PersonId = 1
                        });

                    PrintResponse(response);
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.ToString());
                }
            }
        }

        private static void PrintResponse(PersonalInformationResponse response)
        {
            Console.WriteLine("Received response");
            foreach (var person in response.Persons)
            {
                Console.WriteLine("{0} : {1} {2}", person.Id, person.Name, person.Surname);
            }
        }
    }
}
