﻿using System;
using System.ServiceModel;
using System.ServiceModel.Description;
using System.ServiceProcess;
using PersonalInformationService.ServiceContracts;
using PersonalInformationService.ServiceImplementations;

namespace PersonalInformationHosts.WindowsService
{
    public partial class PersonalInformationWSService : ServiceBase
    {
        private ServiceHost host;

        public PersonalInformationWSService()
        {
            InitializeComponent();
        }

        protected override void OnStart(string[] args)
        {
            RunHost();
            //RunInlineConfiguredHost();
        }

        private void RunHost()
        {
            host = new ServiceHost(typeof(SimplePersonalInformationService));
            host.Open();
        }

        private void RunInlineConfiguredHost()
        {
            string url = "http://localhost:9000/PersonalInformationService";
            host = new ServiceHost(typeof(SimplePersonalInformationService));
            //Add endpoints
            host.AddServiceEndpoint(typeof(IPersonalInformationService),
                new BasicHttpBinding(),
                new Uri(url));

            host.Open();
        }

        protected override void OnStop()
        {
            if (host != null)
            {
                host.Close();
                host = null;
            }
        }

        #region Excercise
        /*
         * If you want to expose Metadata in this service and allow to get it via HTTP
         * use this override of OnStart method
         */
        /*
        private void RunInlineConfiguredHost()
        {
            string url = "http://localhost:9000/PersonalInformationService";
            host = new ServiceHost(typeof(SimplePersonalInformationService), new Uri(url));
            //Add endpoints
            host.AddServiceEndpoint(typeof(IPersonalInformationService),
                new BasicHttpBinding(),
                new Uri(url));

            //Enable MEX
            ServiceMetadataBehavior smb = new ServiceMetadataBehavior();
            smb.HttpGetEnabled = true;
            host.Description.Behaviors.Add(smb);
            host.AddServiceEndpoint(new ServiceMetadataEndpoint(new EndpointAddress(url + "/mex")));

            host.Open();
        }
         */
        #endregion
    }
}