// mutations.spec.js
import Vue from 'vue'
import mutations from 'src/vuex/mutations'
import * as types from 'src/vuex/mutation_types'

describe('mutations', () => {
  var state

  beforeEach(() => {
    state = {}
    // utwórzmy imitację wtyczki noise, aby móc nasłuchiwać jej metod
    Vue.noise = {
      start: () => {},
      stop: () => {},
      pause: () => {}
    }
    sinon.spy(Vue.noise, 'start')
    sinon.spy(Vue.noise, 'pause')
    sinon.spy(Vue.noise, 'stop')
  })

  afterEach(() => {
    Vue.noise.start.restore()
    Vue.noise.pause.restore()
    Vue.noise.stop.restore()
  })

  describe('START', () => {
    it('powinna poprawnie ustawić wszystkie właściwości stanu po uruchomieniu aplikacji', () => {
      // upewnij się, że wszystkie właściwości są niezdefiniowane
      // przed wywołaniem metody start
      expect(state.started).to.be.undefined
      expect(state.stopped).to.be.undefined
      expect(state.paused).to.be.undefined
      expect(state.interval).to.be.undefined
      // wywołaj metodę start
      mutations[types.START](state)
      // sprawdź, czy wszystkie właściwości zostały poprawnie ustawione
      expect(state.started).to.be.true
      expect(state.paused).to.be.false
      expect(state.stopped).to.be.false
      expect(state.interval).not.to.be.undefined
    })

    it('powinna wywołać metodę Vue.noise.start jeżeli właściwości state.isWorking i state.soundEnabled mają wartość true', () => {
      state.isWorking = true
      state.soundEnabled = true
      mutations[types.START](state)
      expect(Vue.noise.start).to.have.been.called
    })

    it('powinna wywołać metodę Vue.noise.start jeżeli właściwość state.isWorking nie ma wartości true', () => {
      state.isWorking = false
      state.soundEnabled = true
      mutations[types.START](state)
      expect(Vue.noise.start).to.not.have.been.called
    })

    it('powinna wywołać metodę Vue.noise.start jeżeli właściwość state.soundEnabled nie ma wartości true', () => {
      state.isWorking = true
      state.soundEnabled = false
      mutations[types.START](state)
      expect(Vue.noise.start).to.not.have.been.called
    })
  })
})
