var data = {
  items: [{ text: 'Banany', checked: true }, { text: 'Jabłka', checked: false }],
  title: 'Moja lista zakupów'
};
// komponent dodawania elementu
Vue.component('add-item-component', {
  template: '#add-item-template',
  data: function () {
    return {
      newItem: ''
    }
  }
});
// komponent elementu
Vue.component('item-component', {
  template: '#item-template',
  props: ['item']
});
// komponent elementów
Vue.component('items-component', {
  template: '#items-template',
  props: ['items']
});
// komponent zmiany nazwy
Vue.component('change-title-component', {
  template: '#change-title-template',
  props: ['value'],
  methods: {
    onInput: function (event) {
      this.$emit('input', event.target.value)
    }
  }
});

new Vue({
  el: '#app',
  data: data,
  methods: {
    addItem: function () {
      var text;

      text = this.newItem.trim();
      if (text) {
        this.items.push({
          text: text,
          checked: false
        });
        this.newItem = "";
      }
    }
  }
});