import { CHANGE_MSG, INCREMENT_COUNTER } from './mutation_types'

export const changeMessage = ({ dispatch }, msg) => {
  dispatch(CHANGE_MSG, msg)
}

export const incrementCounter = ({ dispatch }) => {
  dispatch(INCREMENT_COUNTER)
}

/**
 * Obsługuje zmiany w polu tekstowym msg
 *
 * @param dispatch
 * @param {string} msg - komunikat do zatwierdzenia za pomocą mutacji CHANGE_MSG
 * @param {boolean} increment - jeżeli ma wartość true, powinna zostać wywołana mutacja INCREMENT_COUNTER
 */
export const handleMessageInputChanges = ( { dispatch }, msg, increment ) => {
  dispatch(CHANGE_MSG, msg);
  if (increment) {
    dispatch(INCREMENT_COUNTER)
  }
}