const POMODORO_STATES = {
  WORK: "work",
  REST: "rest"
};
const STATES = {
  STARTED: "started",
  STOPPED: "stopped",
  PAUSED: "paused"
};
const WORKING_TIME_LENGTH_IN_MINUTES = 1;
const RESTING_TIME_LENGTH_IN_MINUTES = 10;

new Vue({
  el: "#app",
  data: {
    state: STATES.STOPPED,
    minute: WORKING_TIME_LENGTH_IN_MINUTES,
    second: 0,
    pomodoroState: POMODORO_STATES.WORK,
    timestamp: 0
  },
  computed: {
    title: function () {
      return this.pomodoroState === POMODORO_STATES.WORK ? "Pracuj!" : "Odpoczywaj!"
    },
    min: function () {
      if (this.minute < 10) {
        return "0" + this.minute;
      }

      return this.minute;
    },
    sec: function () {
      if (this.second < 10) {
        return "0" + this.second;
      }

      return this.second;
    },
    catImgSrc: function () {
      return "http://thecatapi.com/api/images/get?type=gif&size=med&ts=" + this.timestamp;
    }
  },
  methods: {
    start: function () {
      this.state = STATES.STARTED;
      this._tick();
      this.interval = setInterval(this._tick, 1000);
    },
    pause: function () {
      this.state = STATES.PAUSED;
      clearInterval(this.interval);
    },
    stop: function () {
      this.state = STATES.STOPPED;
      clearInterval(this.interval);
      this.pomodoroState = POMODORO_STATES.WORK;
      this.minute = WORKING_TIME_LENGTH_IN_MINUTES;
      this.second = 0;
    },
    _tick: function () {
      // aktualizuj znacznik czasu wykorzystywany w atrybucie src obrazu
      if (this.second % 10 === 0) {
        this.timestamp = new Date().getTime();
      }
      // jeżeli wartość second jest większa od 0, zmniejsz ją o 1
      if (this.second !== 0) {
        this.second--;
        return;
      }
      // jeśli second ma wartość 0, ale minute nie, zmniejsz minute o 1 i nadaj second wartość 59
      if (this.minute !== 0) {
        this.minute--;
        this.second = 59;
        return;
      }
      // jeśli i second, i minute są równe 0, przełącz między czasem pracy a odpoczynkiem
      this.pomodoroState = this.pomodoroState === POMODORO_STATES.WORK ? POMODORO_STATES.REST : POMODORO_STATES.WORK;
      if (this.pomodoroState === POMODORO_STATES.WORK) {
        this.minute = WORKING_TIME_LENGTH_IN_MINUTES;
      } else {
        this.minute = RESTING_TIME_LENGTH_IN_MINUTES;
      }
    }
  }
});