"use strict";

exports.__esModule = true;

var _keys = require("babel-runtime/core-js/object/keys");

var _keys2 = _interopRequireDefault(_keys);

var _typeof2 = require("babel-runtime/helpers/typeof");

var _typeof3 = _interopRequireDefault(_typeof2);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _sourceMap = require("source-map");

var _sourceMap2 = _interopRequireDefault(_sourceMap);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Build a sourcemap.
 */

var SourceMap = function () {
  function SourceMap(opts, code) {
    var _this = this;

    (0, _classCallCheck3.default)(this, SourceMap);

    this.opts = opts;
    this.last = { generated: {}, original: {} };

    if (opts.sourceMaps) {
      this.map = new _sourceMap2.default.SourceMapGenerator({
        file: opts.sourceMapTarget,
        sourceRoot: opts.sourceRoot
      });

      if (typeof code === "string") {
        this.map.setSourceContent(opts.sourceFileName, code);
      } else if ((typeof code === "undefined" ? "undefined" : (0, _typeof3.default)(code)) === "object") {
        (0, _keys2.default)(code).forEach(function (sourceFileName) {
          _this.map.setSourceContent(sourceFileName, code[sourceFileName]);
        });
      }
    } else {
      this.map = null;
    }
  }

  /**
   * Get the sourcemap.
   */

  SourceMap.prototype.get = function get() {
    var map = this.map;
    if (map) {
      return map.toJSON();
    } else {
      return map;
    }
  };

  /**
   * Mark the current generated position with a source position. May also be passed null line/column
   * values to insert a mapping to nothing.
   */

  SourceMap.prototype.mark = function mark(position, line, column, filename) {
    var map = this.map;
    if (!map) return; // no source map

    // Adding an empty mapping at the start of a generated line just clutters the map.
    if (this._lastGenLine !== position.line && line === null) return;

    // If this mapping points to the same source location as the last one, we can ignore it since
    // the previous one covers it.
    if (this._lastGenLine === position.line && this._lastSourceLine === line && this._lastSourceColumn === column) {
      return;
    }

    this._lastGenLine = position.line;
    this._lastSourceLine = line;
    this._lastSourceColumn = column;

    map.addMapping({
      generated: {
        line: position.line,
        column: position.column
      },
      source: line == null ? null : filename || this.opts.sourceFileName,
      original: line == null ? null : {
        line: line,
        column: column
      }
    });
  };

  return SourceMap;
}();

exports.default = SourceMap;
module.exports = exports["default"];