import Vue from 'vue'
import App from './App'
import VueNoiseGeneratorPlugin from '../plugins/VueNoiseGeneratorPlugin'

Vue.use(VueNoiseGeneratorPlugin)
/* eslint-disable no-new */

/**
 * Dodaje zero po lewej stronie, jeśli wartość number jest mniejsza od 10
 *
 * @param {number} value
 * @returns {string}
 */
Vue.filter('leftpad', (value) => {
  if (value >= 10) {
    return value
  }

  return '0' + value;
})
/**
 * Zamienia litery ciągu znaków na wielkie
 *
 * @param {string} value
 * @returns {string}
 */
Vue.filter('uppercase', (value) => {
  return value.toUpperCase();
})
/**
 * Dodaje spację na końcu ciągu znaków
 *
 * @param {string} value
 * @returns {string}
 */
Vue.filter('addspace', (value) => {
  return value + ' ';
})

new Vue({
  el: 'body',
  components: { App }
})
