import { CHANGE_TITLE, POPULATE_SHOPPING_LISTS, ADD_SHOPPING_LIST, DELETE_SHOPPING_LIST } from './mutation_types'
import api from '../api'
import { getListById } from './getters'
/**
 * Pobiera i wypełnia listy zakupów
 */
export const populateShoppingLists = ({ dispatch }) => {
  api.fetchShoppingLists().then(response => {
    dispatch(POPULATE_SHOPPING_LISTS, response.data)
  })
}
/**
 * Zmienia nazwę listy zakupów
 * @param store
 * @param title
 * @param id
 */
export const changeTitle = (store, title, id) => {
  store.dispatch(CHANGE_TITLE, title, id)
  updateList(store, id)
}
/**
 * Aktualizuje listę zakupów na podstawie jej identyfikatora
 * @param store
 * @param id
 */
export const updateList = (store, id) => {
  var shoppingList = getListById(store.state, id)

  api.updateShoppingList(shoppingList)
}
/**
 * Tworzy nową listę zakupów
 * @param dispatch
 * @param shoppingList
 */
export const createShoppingList = ({ dispatch }, shoppingList) => {
  api.addNewShoppingList(shoppingList).then(() => {
    populateShoppingLists({dispatch})
  })
}
/**
 * Usuwa listę zakupów z listy
 * @param dispatch
 * @param id
 */
export const deleteShoppingList = ({ dispatch }, id) => {
  api.deleteShoppingList(id).then(() => {
    populateShoppingLists({dispatch})
  })
}
