/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.Selenium;
import java.io.File;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.internal.IResultListener;

public class ScreenshotListener
implements IResultListener {
    File outputDirectory;
    Selenium selenium;

    public ScreenshotListener(File outputDirectory, Selenium selenium) {
        this.outputDirectory = outputDirectory;
        this.selenium = selenium;
    }

    @Override
    public void onTestFailure(ITestResult result) {
        Reporter.setCurrentTestResult(result);
        try {
            this.outputDirectory.mkdirs();
            File outFile = File.createTempFile("TEST-" + result.getName(), ".png", this.outputDirectory);
            outFile.delete();
            this.selenium.captureScreenshot(outFile.getAbsolutePath());
            Reporter.log("<a href='" + outFile.getName() + "'>screenshot</a>");
        }
        catch (Exception e) {
            e.printStackTrace();
            Reporter.log("Couldn't create screenshot");
            Reporter.log(e.getMessage());
        }
        Reporter.setCurrentTestResult(null);
    }

    @Override
    public void onConfigurationFailure(ITestResult result) {
        this.onTestFailure(result);
    }

    @Override
    public void onFinish(ITestContext context) {
    }

    @Override
    public void onStart(ITestContext context) {
        this.outputDirectory = new File(context.getOutputDirectory());
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    @Override
    public void onTestSkipped(ITestResult result) {
    }

    @Override
    public void onTestStart(ITestResult result) {
    }

    @Override
    public void onTestSuccess(ITestResult result) {
    }

    @Override
    public void onConfigurationSuccess(ITestResult itr) {
    }

    @Override
    public void onConfigurationSkip(ITestResult itr) {
    }
}

