/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.internal.HttpClientFactory;
import org.openqa.selenium.remote.server.log.LoggingManager;

public class SelfRegisteringRemote {
    private static final Logger LOG = Logger.getLogger(SelfRegisteringRemote.class.getName());
    private RegistrationRequest nodeConfig;
    private final HttpClientFactory httpClientFactory;
    private GridNodeServer server;

    public SelfRegisteringRemote(RegistrationRequest config) {
        this.nodeConfig = config;
        this.httpClientFactory = new HttpClientFactory();
        this.nodeConfig.validate();
        try {
            JsonObject hubParameters = this.getHubConfiguration();
            if (hubParameters.has("timeout")) {
                int timeout = hubParameters.get("timeout").getAsInt();
                this.nodeConfig.getConfiguration().put("timeout", timeout);
            }
            if (hubParameters.has("browserTimeout")) {
                int browserTimeout = hubParameters.get("browserTimeout").getAsInt();
                this.nodeConfig.getConfiguration().put("browserTimeout", browserTimeout);
            }
        }
        catch (Exception e) {
            LOG.warning("error getting the parameters from the hub. The node may end up with wrong timeouts." + e.getMessage());
        }
    }

    public URL getRemoteURL() {
        String host = (String)this.nodeConfig.getConfiguration().get("host");
        String port = (String)this.nodeConfig.getConfiguration().get("port");
        String url = "http://" + host + ":" + port;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GridConfigurationException("error building the node url " + e.getMessage(), e);
        }
    }

    public void setRemoteServer(GridNodeServer server) {
        this.server = server;
    }

    public void startRemoteServer() throws Exception {
        if (this.server == null) {
            throw new GridConfigurationException("no server set to register to the hub");
        }
        this.server.boot();
    }

    public void stopRemoteServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void deleteAllBrowsers() {
        this.nodeConfig.getCapabilities().clear();
    }

    public void addBrowser(DesiredCapabilities cap, int instances) {
        String s = cap.getBrowserName();
        if (s == null || "".equals(s)) {
            throw new InvalidParameterException(cap + " does seems to be a valid browser.");
        }
        if (cap.getPlatform() == null) {
            cap.setPlatform(Platform.getCurrent());
        }
        cap.setCapability("maxInstances", instances);
        this.nodeConfig.getCapabilities().add(cap);
    }

    public void sendRegistrationRequest() {
        this.registerToHub(false);
    }

    public void startRegistrationProcess() {
        LOG.fine("Using the json request : " + this.nodeConfig.toJSON());
        Boolean register = (Boolean)this.nodeConfig.getConfiguration().get("register");
        if (!register.booleanValue()) {
            LOG.info("No registration sent ( register = false )");
        } else {
            final int registerCycleInterval = this.nodeConfig.getConfigAsInt("registerCycle", 0);
            if (registerCycleInterval > 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean first = true;
                        LOG.info("Starting auto registration thread. Will try to register every " + registerCycleInterval + " ms.");
                        while (true) {
                            try {
                                boolean checkForPresence = true;
                                if (first) {
                                    first = false;
                                    checkForPresence = false;
                                }
                                SelfRegisteringRemote.this.registerToHub(checkForPresence);
                            }
                            catch (GridException e) {
                                LOG.info("Couldn't register this node: " + e.getMessage());
                            }
                            try {
                                Thread.sleep(registerCycleInterval);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            LoggingManager.perSessionLogHandler().clearThreadTempLogs();
                        }
                    }
                }).start();
            } else {
                this.registerToHub(false);
            }
        }
        LoggingManager.perSessionLogHandler().clearThreadTempLogs();
    }

    public void setTimeout(int timeout, int cycle) {
        this.nodeConfig.getConfiguration().put("timeout", timeout);
        this.nodeConfig.getConfiguration().put("cleanUpCycle", cycle);
    }

    public void setMaxConcurrent(int max) {
        this.nodeConfig.getConfiguration().put("maxSession", max);
    }

    public Map<String, Object> getConfiguration() {
        return this.nodeConfig.getConfiguration();
    }

    private void registerToHub(boolean checkPresenceFirst) {
        if (!checkPresenceFirst || !this.isAlreadyRegistered(this.nodeConfig)) {
            String tmp = "http://" + this.nodeConfig.getConfiguration().get("hubHost") + ":" + this.nodeConfig.getConfiguration().get("hubPort") + "/grid/register";
            HttpClient client = this.httpClientFactory.getHttpClient();
            try {
                URL registration = new URL(tmp);
                LOG.info("Registering the node to the hub: " + registration);
                BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest("POST", registration.toExternalForm());
                this.updateConfigWithRealPort();
                String json = this.nodeConfig.toJSON();
                r.setEntity(new StringEntity(json, "UTF-8"));
                HttpHost host = new HttpHost(registration.getHost(), registration.getPort());
                HttpResponse response = client.execute(host, r);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new GridException(String.format("The hub responded with %s:%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                }
                LOG.info("The node is registered to the hub and ready to use");
            }
            catch (Exception e) {
                throw new GridException("Error sending the registration request: " + e.getMessage());
            }
        } else {
            LOG.fine("The node is already present on the hub. Skipping registration.");
        }
    }

    void updateConfigWithRealPort() throws MalformedURLException {
        int port = Integer.parseInt(this.nodeConfig.getConfigAsString("port"));
        if (port != 0) {
            return;
        }
        port = this.server.getRealPort();
        Map<String, Object> config = this.nodeConfig.getConfiguration();
        config.put("port", this.server.getRealPort());
        URL url = new URL(this.nodeConfig.getConfigAsString("remoteHost"));
        String newUrl = String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + port;
        config.put("remoteHost", newUrl);
    }

    private JsonObject getHubConfiguration() throws Exception {
        String hubApi = "http://" + this.nodeConfig.getConfiguration().get("hubHost") + ":" + this.nodeConfig.getConfiguration().get("hubPort") + "/grid/api/hub";
        HttpClient client = this.httpClientFactory.getHttpClient();
        URL api = new URL(hubApi);
        HttpHost host = new HttpHost(api.getHost(), api.getPort());
        String url = api.toExternalForm();
        BasicHttpRequest r = new BasicHttpRequest("GET", url);
        HttpResponse response = client.execute(host, r);
        return SelfRegisteringRemote.extractObject(response);
    }

    private boolean isAlreadyRegistered(RegistrationRequest node) {
        HttpClient client = this.httpClientFactory.getHttpClient();
        try {
            BasicHttpRequest r;
            HttpResponse response;
            String tmp = "http://" + node.getConfiguration().get("hubHost") + ":" + node.getConfiguration().get("hubPort") + "/grid/api/proxy";
            URL api = new URL(tmp);
            HttpHost host = new HttpHost(api.getHost(), api.getPort());
            String id = (String)node.getConfiguration().get("id");
            if (id == null) {
                id = (String)node.getConfiguration().get("remoteHost");
            }
            if ((response = client.execute(host, r = new BasicHttpRequest("GET", String.valueOf(api.toExternalForm()) + "?id=" + id))).getStatusLine().getStatusCode() != 200) {
                throw new GridException(String.format("The hub responded with %s:%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            JsonObject o = SelfRegisteringRemote.extractObject(response);
            return o.get("success").getAsBoolean();
        }
        catch (Exception e) {
            throw new GridException("The hub is down or not responding: " + e.getMessage());
        }
    }

    private static JsonObject extractObject(HttpResponse resp) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));
        StringBuilder s = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            s.append(line);
        }
        rd.close();
        return new JsonParser().parse(s.toString()).getAsJsonObject();
    }
}

