/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpConnection;
import org.openqa.jetty.http.HttpHandler;
import org.openqa.jetty.http.HttpListener;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpServer;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.InetAddrPort;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.ThreadedServer;

public class SocketListener
extends ThreadedServer
implements HttpListener {
    private static Log log = LogFactory.getLog(SocketListener.class);
    private int _lowResourcePersistTimeMs = 2000;
    private String _scheme = "http";
    private String _integralScheme = "https";
    private String _confidentialScheme = "https";
    private int _integralPort = 0;
    private int _confidentialPort = 0;
    private boolean _identifyListener = false;
    private int _bufferSize = Integer.getInteger("org.openqa.jetty.SocketListener.bufferSize", 8192);
    private int _bufferReserve = 512;
    private HttpHandler _handler;
    private int _lowResources;
    private transient HttpServer _server;
    private transient boolean _isLow = false;
    private transient boolean _isOut = false;
    private transient long _warned = 0L;

    public SocketListener() {
    }

    public SocketListener(InetAddrPort address) {
        super(address);
    }

    @Override
    public HttpServer getHttpServer() {
        return this._server;
    }

    @Override
    public void setHttpServer(HttpServer server) {
        if (server != null && this._server != null && this._server != server) {
            throw new IllegalStateException("Cannot share listeners");
        }
        this._server = server;
    }

    @Override
    public HttpHandler getHttpHandler() {
        return this._handler;
    }

    public void setHttpHandler(HttpHandler handler) {
        this._handler = handler;
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    @Override
    public int getBufferReserve() {
        return this._bufferReserve;
    }

    public void setBufferReserve(int size) {
        this._bufferReserve = size;
    }

    public boolean getIdentifyListener() {
        return this._identifyListener;
    }

    public void setIdentifyListener(boolean identifyListener) {
        this._identifyListener = identifyListener;
    }

    public void setDefaultScheme(String scheme) {
        this._scheme = scheme;
    }

    @Override
    public String getDefaultScheme() {
        return this._scheme;
    }

    public int getLowResources() {
        return this._lowResources;
    }

    public void setLowResources(int lowResources) {
        this._lowResources = lowResources;
    }

    public int getLowResourcePersistTimeMs() {
        return this._lowResourcePersistTimeMs;
    }

    public void setLowResourcePersistTimeMs(int ms) {
        this._lowResourcePersistTimeMs = ms;
    }

    @Override
    public void start() throws Exception {
        super.start();
        log.info("Started SocketListener on " + this.getInetAddrPort());
    }

    @Override
    public void stop() throws InterruptedException {
        super.stop();
        log.info("Stopped SocketListener on " + this.getInetAddrPort());
    }

    @Override
    public void handleConnection(Socket socket) throws IOException {
        HttpConnection connection = this.createConnection(socket);
        try {
            if (this._lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                socket.setSoTimeout(this._lowResourcePersistTimeMs);
                connection.setThrottled(true);
            } else {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
                connection.setThrottled(false);
            }
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
        }
        connection.handle();
    }

    protected HttpConnection createConnection(Socket socket) throws IOException {
        HttpConnection c = new HttpConnection(this, socket.getInetAddress(), socket.getInputStream(), socket.getOutputStream(), socket);
        return c;
    }

    @Override
    public void customizeRequest(HttpConnection connection, HttpRequest request) {
        if (this._identifyListener) {
            request.setAttribute("org.openqa.jetty.http.HttpListener", this.getName());
        }
        Socket socket = (Socket)connection.getConnection();
        this.customizeRequest(socket, request);
    }

    protected void customizeRequest(Socket socket, HttpRequest request) {
        try {
            if (request.getHttpConnection().isThrottled()) {
                socket.setSoTimeout(this.getMaxIdleTimeMs());
                request.getHttpConnection().setThrottled(false);
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
    }

    @Override
    public void persistConnection(HttpConnection connection) {
        try {
            Socket socket = (Socket)connection.getConnection();
            if (this._lowResourcePersistTimeMs > 0 && this.isLowOnResources()) {
                socket.setSoTimeout(this._lowResourcePersistTimeMs);
                connection.setThrottled(true);
            } else {
                connection.setThrottled(false);
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
    }

    @Override
    public boolean isLowOnResources() {
        boolean low;
        int spare = this.getMaxThreads() - this.getThreads();
        int lr = this._lowResources > 0 ? this._lowResources : this.getMinThreads();
        boolean bl = low = spare + this.getIdleThreads() < lr;
        if (low && !this._isLow) {
            log.info("LOW ON THREADS ((" + this.getMaxThreads() + "-" + this.getThreads() + "+" + this.getIdleThreads() + ")<" + this.getMinThreads() + ") on " + this);
            this._warned = System.currentTimeMillis();
            this._isLow = true;
        } else if (!low && this._isLow && System.currentTimeMillis() - this._warned > 1000L) {
            this._isOut = false;
            this._isLow = false;
        }
        return low;
    }

    @Override
    public boolean isOutOfResources() {
        boolean out;
        boolean bl = out = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (out && !this._isOut) {
            log.warn("OUT OF THREADS: " + this);
            this._warned = System.currentTimeMillis();
            this._isLow = true;
            this._isOut = true;
        }
        return out;
    }

    @Override
    public boolean isIntegral(HttpConnection connection) {
        return false;
    }

    @Override
    public boolean isConfidential(HttpConnection connection) {
        return false;
    }

    @Override
    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public void setIntegralScheme(String integralScheme) {
        this._integralScheme = integralScheme;
    }

    @Override
    public int getIntegralPort() {
        return this._integralPort;
    }

    public void setIntegralPort(int integralPort) {
        this._integralPort = integralPort;
    }

    @Override
    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public void setConfidentialScheme(String confidentialScheme) {
        this._confidentialScheme = confidentialScheme;
    }

    @Override
    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public void setConfidentialPort(int confidentialPort) {
        this._confidentialPort = confidentialPort;
    }
}

