/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.IOException;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.Authenticator;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.UserRealm;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.B64Code;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.StringUtil;

public class BasicAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog(BasicAuthenticator.class);

    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        Principal user = null;
        String credentials = request.getField("Authorization");
        if (credentials != null) {
            try {
                String password;
                int i;
                if (log.isDebugEnabled()) {
                    log.debug("Credentials: " + credentials);
                }
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                String username = (credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1)).substring(0, i = credentials.indexOf(58));
                user = realm.authenticate(username, password = credentials.substring(i + 1), request);
                if (user == null) {
                    log.warn("AUTH FAILURE: user " + username);
                } else {
                    request.setAuthType("BASIC");
                    request.setAuthUser(username);
                    request.setUserPrincipal(user);
                }
            }
            catch (Exception e) {
                log.warn("AUTH FAILURE: " + e.toString());
                LogSupport.ignore(log, e);
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, response);
        }
        return user;
    }

    @Override
    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm realm, HttpResponse response) throws IOException {
        response.setField("WWW-Authenticate", "basic realm=\"" + realm.getName() + '\"');
        response.sendError(401);
    }
}

