/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.beta;

import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.web.utils.BrowserNameUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class MiniCapability {
    private String browser;
    private String version;
    private DesiredCapabilities capabilities;
    private RemoteProxy proxy;

    public MiniCapability(TestSlot slot) {
        DesiredCapabilities cap = new DesiredCapabilities(slot.getCapabilities());
        this.browser = cap.getBrowserName();
        this.version = cap.getVersion();
        this.capabilities = cap;
        this.proxy = slot.getProxy();
    }

    public String getVersion() {
        return this.version;
    }

    public String getIcon() {
        return BrowserNameUtils.getConsoleIconPath(new DesiredCapabilities((Capabilities)this.capabilities), this.proxy.getRegistry());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.browser == null ? 0 : this.browser.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MiniCapability other = (MiniCapability)obj;
        if (this.browser == null ? other.browser != null : !this.browser.equals(other.browser)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

