/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.http.PathMap;
import org.openqa.jetty.jetty.servlet.FilterHolder;
import org.openqa.jetty.jetty.servlet.JSR154Filter;
import org.openqa.jetty.jetty.servlet.ServletHandler;
import org.openqa.jetty.jetty.servlet.ServletHolder;
import org.openqa.jetty.jetty.servlet.ServletHttpContext;
import org.openqa.jetty.jetty.servlet.ServletHttpRequest;
import org.openqa.jetty.jetty.servlet.ServletHttpResponse;
import org.openqa.jetty.jetty.servlet.SessionManager;
import org.openqa.jetty.jetty.servlet.WebApplicationContext;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LazyList;
import org.openqa.jetty.util.MultiException;
import org.openqa.jetty.util.MultiMap;
import org.openqa.jetty.util.StringUtil;
import org.openqa.jetty.util.TypeUtil;

public class WebApplicationHandler
extends ServletHandler {
    private static Log log = LogFactory.getLog(WebApplicationHandler.class);
    private Map _filterMap = new HashMap();
    private List _pathFilters = new ArrayList();
    private List _filters = new ArrayList();
    private MultiMap _servletFilterMap = new MultiMap();
    private boolean _acceptRanges = true;
    private boolean _filterChainsCached = true;
    private transient WebApplicationContext _webApplicationContext;
    protected transient Object _requestListeners;
    protected transient Object _requestAttributeListeners;
    protected transient Object _sessionListeners;
    protected transient Object _contextAttributeListeners;
    protected transient FilterHolder jsr154FilterHolder;
    protected transient JSR154Filter jsr154Filter;
    protected transient HashMap[] _chainCache;
    protected transient HashMap[] _namedChainCache;

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public void setAcceptRanges(boolean ar) {
        this._acceptRanges = ar;
    }

    public JSR154Filter getJsr154Filter() {
        return this.jsr154Filter;
    }

    public FilterHolder defineFilter(String name, String className) {
        FilterHolder holder = this.newFilterHolder(name, className);
        this.addFilterHolder(holder);
        return holder;
    }

    protected FilterHolder newFilterHolder(String name, String className) {
        return new FilterHolder(this, name, className);
    }

    public void addFilterHolder(FilterHolder holder) {
        this._filterMap.put(holder.getName(), holder);
        this._filters.add(holder);
        this.addComponent(holder);
    }

    public FilterHolder getFilter(String name) {
        return (FilterHolder)this._filterMap.get(name);
    }

    public FilterHolder addFilterPathMapping(String pathSpec, String filterName, int dispatches) {
        FilterHolder holder = (FilterHolder)this._filterMap.get(filterName);
        if (holder == null) {
            throw new IllegalArgumentException("unknown filter: " + filterName);
        }
        FilterMapping mapping = new FilterMapping(pathSpec, holder, dispatches);
        this._pathFilters.add(mapping);
        return holder;
    }

    public FilterHolder addFilterServletMapping(String servletName, String filterName, int dispatches) {
        FilterHolder holder = (FilterHolder)this._filterMap.get(filterName);
        if (holder == null) {
            throw new IllegalArgumentException("Unknown filter :" + filterName);
        }
        this._servletFilterMap.add(servletName, new FilterMapping(null, holder, dispatches));
        return holder;
    }

    public List getFilters() {
        return this._filters;
    }

    @Override
    public synchronized void addEventListener(EventListener listener) throws IllegalArgumentException {
        if (listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener) {
            if (this._sessionManager != null) {
                this._sessionManager.addEventListener(listener);
            }
            this._sessionListeners = LazyList.add(this._sessionListeners, listener);
        }
        if (listener instanceof ServletRequestListener) {
            this._requestListeners = LazyList.add(this._requestListeners, listener);
        }
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, listener);
        }
        if (listener instanceof ServletContextAttributeListener) {
            this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, listener);
        }
        super.addEventListener(listener);
    }

    @Override
    public synchronized void removeEventListener(EventListener listener) {
        if (this._sessionManager != null) {
            this._sessionManager.removeEventListener(listener);
        }
        this._sessionListeners = LazyList.remove(this._sessionListeners, listener);
        this._requestListeners = LazyList.remove(this._requestListeners, listener);
        this._requestAttributeListeners = LazyList.remove(this._requestAttributeListeners, listener);
        this._contextAttributeListeners = LazyList.remove(this._contextAttributeListeners, listener);
        super.removeEventListener(listener);
    }

    @Override
    public void setSessionManager(SessionManager sm) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        SessionManager old = this.getSessionManager();
        if (this.getHttpContext() != null) {
            EventListener listener;
            Iterator i;
            if (old != null && old != sm && this._sessionListeners != null) {
                i = LazyList.iterator(this._sessionListeners);
                while (i.hasNext()) {
                    listener = (EventListener)i.next();
                    this._sessionManager.removeEventListener(listener);
                }
            }
            if (sm != null && old != sm && this._sessionListeners != null) {
                i = LazyList.iterator(this._sessionListeners);
                while (i.hasNext()) {
                    listener = (EventListener)i.next();
                    sm.addEventListener(listener);
                }
            }
        }
        super.setSessionManager(sm);
    }

    @Override
    protected synchronized void doStart() throws Exception {
        super.doStart();
        if (log.isDebugEnabled()) {
            log.debug("Path Filters: " + this._pathFilters);
        }
        if (log.isDebugEnabled()) {
            log.debug("Servlet Filters: " + this._servletFilterMap);
        }
        if (this.getHttpContext() instanceof WebApplicationContext) {
            this._webApplicationContext = (WebApplicationContext)this.getHttpContext();
        }
        if (this._filterChainsCached) {
            this._chainCache = this.getChainCache();
            this._namedChainCache = this.getChainCache();
        }
    }

    private HashMap[] getChainCache() {
        HashMap[] _chainCache = new HashMap[9];
        _chainCache[1] = new HashMap();
        _chainCache[2] = new HashMap();
        _chainCache[4] = new HashMap();
        _chainCache[8] = new HashMap();
        return _chainCache;
    }

    @Override
    public void initializeServlets() throws Exception {
        MultiException mex = new MultiException();
        for (FilterHolder holder : this._filters) {
            try {
                holder.start();
            }
            catch (Exception e) {
                mex.add(e);
            }
        }
        try {
            super.initializeServlets();
        }
        catch (Exception e) {
            mex.add(e);
        }
        this.jsr154FilterHolder = this.getFilter("jsr154");
        if (this.jsr154FilterHolder != null) {
            this.jsr154Filter = (JSR154Filter)this.jsr154FilterHolder.getFilter();
        }
        log.debug("jsr154filter=" + this.jsr154Filter);
        if (LazyList.size(this._requestAttributeListeners) > 0 || LazyList.size(this._requestListeners) > 0) {
            if (this.jsr154Filter == null) {
                log.warn("Filter jsr154 not defined for RequestAttributeListeners");
            } else {
                this.jsr154Filter.setRequestAttributeListeners(this._requestAttributeListeners);
                this.jsr154Filter.setRequestListeners(this._requestListeners);
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    protected synchronized void doStop() throws Exception {
        try {
            super.doStop();
            int i = this._filters.size();
            while (i-- > 0) {
                FilterHolder holder = (FilterHolder)this._filters.get(i);
                holder.stop();
            }
        }
        finally {
            this._webApplicationContext = null;
            this._sessionListeners = null;
            this._requestListeners = null;
            this._requestAttributeListeners = null;
            this._contextAttributeListeners = null;
        }
    }

    @Override
    public String getErrorPage(int status, ServletHttpRequest request) {
        String error_page = null;
        Class<Object> exClass = (Class)request.getAttribute("javax.servlet.error.exception_type");
        if (ServletException.class.equals((Object)exClass) && (error_page = this._webApplicationContext.getErrorPage(exClass.getName())) == null) {
            Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
            while (th instanceof ServletException) {
                th = ((ServletException)th).getRootCause();
            }
            if (th != null) {
                exClass = th.getClass();
            }
        }
        if (error_page == null && exClass != null) {
            while (error_page == null && exClass != null && this._webApplicationContext != null) {
                error_page = this._webApplicationContext.getErrorPage(exClass.getName());
                exClass = exClass.getSuperclass();
            }
        }
        if (error_page == null && this._webApplicationContext != null) {
            error_page = this._webApplicationContext.getErrorPage(TypeUtil.toString(status));
        }
        return error_page;
    }

    @Override
    protected void dispatch(String pathInContext, HttpServletRequest request, HttpServletResponse response, ServletHolder servletHolder, int type) throws ServletException, UnavailableException, IOException {
        if (type == 1) {
            ServletHttpRequest servletHttpRequest = (ServletHttpRequest)request;
            ServletHttpResponse servletHttpResponse = (ServletHttpResponse)response;
            if (StringUtil.startsWithIgnoreCase(pathInContext, "/web-inf") || StringUtil.startsWithIgnoreCase(pathInContext, "/meta-inf")) {
                response.sendError(404);
                return;
            }
            if (!this.getHttpContext().checkSecurityConstraints(pathInContext, servletHttpRequest.getHttpRequest(), servletHttpResponse.getHttpResponse())) {
                return;
            }
        } else {
            HttpContext context = this.getHttpContext();
            if (context != null && context instanceof ServletHttpContext && pathInContext != null && pathInContext.endsWith("j_security_check")) {
                ServletHttpRequest servletHttpRequest = (ServletHttpRequest)context.getHttpConnection().getRequest().getWrapper();
                ServletHttpResponse servletHttpResponse = servletHttpRequest.getServletHttpResponse();
                ServletHttpContext servletContext = (ServletHttpContext)context;
                if (!servletContext.jSecurityCheck(pathInContext, servletHttpRequest.getHttpRequest(), servletHttpResponse.getHttpResponse())) {
                    return;
                }
            }
        }
        FilterChain chain = null;
        chain = pathInContext != null ? this.getChainForPath(type, pathInContext, servletHolder) : this.getChainForName(type, servletHolder);
        if (log.isDebugEnabled()) {
            log.debug("chain=" + chain);
        }
        if (chain != null) {
            chain.doFilter(request, response);
        } else if (servletHolder != null) {
            servletHolder.handle(request, response);
        } else {
            this.notFound(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getChainForName(int requestType, ServletHolder servletHolder) {
        if (servletHolder == null) {
            throw new IllegalStateException("Named dispatch must be to an explicitly named servlet");
        }
        if (this._filterChainsCached) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                if (this._namedChainCache[requestType].containsKey(servletHolder.getName())) {
                    return (FilterChain)this._namedChainCache[requestType].get(servletHolder.getName());
                }
            }
        }
        Object filters = null;
        if (this.jsr154Filter != null) {
            filters = LazyList.add(filters, this.jsr154FilterHolder);
        }
        if (this._servletFilterMap.size() > 0) {
            Object o = this._servletFilterMap.get(servletHolder.getName());
            int i = 0;
            while (i < LazyList.size(o)) {
                FilterMapping mapping = (FilterMapping)LazyList.get(o, i);
                if (mapping.appliesTo(null, requestType)) {
                    filters = LazyList.add(filters, mapping.getHolder());
                }
                ++i;
            }
        }
        FilterChain chain = null;
        if (this._filterChainsCached) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                if (LazyList.size(filters) > 0) {
                    chain = new CachedChain(filters, servletHolder);
                }
                this._namedChainCache[requestType].put(servletHolder.getName(), chain);
            }
        } else if (LazyList.size(filters) > 0) {
            chain = new Chain(filters, servletHolder);
        }
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterChain getChainForPath(int requestType, String pathInContext, ServletHolder servletHolder) {
        if (this._filterChainsCached) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                if (this._chainCache[requestType].containsKey(pathInContext)) {
                    return (FilterChain)this._chainCache[requestType].get(pathInContext);
                }
            }
        }
        Object filters = null;
        int i = 0;
        while (i < this._pathFilters.size()) {
            FilterMapping mapping = (FilterMapping)this._pathFilters.get(i);
            if (mapping.appliesTo(pathInContext, requestType)) {
                filters = LazyList.add(filters, mapping.getHolder());
            }
            ++i;
        }
        if (servletHolder != null && this._servletFilterMap.size() > 0) {
            Object o = this._servletFilterMap.get(servletHolder.getName());
            int i2 = 0;
            while (i2 < LazyList.size(o)) {
                FilterMapping mapping = (FilterMapping)LazyList.get(o, i2);
                if (mapping.appliesTo(null, requestType)) {
                    filters = LazyList.add(filters, mapping.getHolder());
                }
                ++i2;
            }
        }
        FilterChain chain = null;
        if (this._filterChainsCached) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                if (LazyList.size(filters) > 0) {
                    chain = new CachedChain(filters, servletHolder);
                }
                this._chainCache[requestType].put(pathInContext, chain);
            }
        } else if (LazyList.size(filters) > 0) {
            chain = new Chain(filters, servletHolder);
        }
        return chain;
    }

    @Override
    public synchronized void setContextAttribute(String name, Object value) {
        Object old = super.getContextAttribute(name);
        super.setContextAttribute(name, value);
        if (this._contextAttributeListeners != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, old != null ? old : value);
            int i = 0;
            while (i < LazyList.size(this._contextAttributeListeners)) {
                ServletContextAttributeListener l = (ServletContextAttributeListener)LazyList.get(this._contextAttributeListeners, i);
                if (old == null) {
                    l.attributeAdded(event);
                } else if (value == null) {
                    l.attributeRemoved(event);
                } else {
                    l.attributeReplaced(event);
                }
                ++i;
            }
        }
    }

    @Override
    public synchronized void removeContextAttribute(String name) {
        Object old = super.getContextAttribute(name);
        super.removeContextAttribute(name);
        if (old != null && this._contextAttributeListeners != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, old);
            int i = 0;
            while (i < LazyList.size(this._contextAttributeListeners)) {
                ServletContextAttributeListener l = (ServletContextAttributeListener)LazyList.get(this._contextAttributeListeners, i);
                l.attributeRemoved(event);
                ++i;
            }
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    public void setFilterChainsCached(boolean filterChainsCached) {
        this._filterChainsCached = filterChainsCached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addComponent(Object o) {
        if (this._filterChainsCached && this.isStarted()) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                int i = 0;
                while (i < this._chainCache.length) {
                    if (this._chainCache[i] != null) {
                        this._chainCache[i].clear();
                    }
                    ++i;
                }
            }
        }
        super.addComponent(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeComponent(Object o) {
        if (this._filterChainsCached && this.isStarted()) {
            WebApplicationHandler webApplicationHandler = this;
            synchronized (webApplicationHandler) {
                int i = 0;
                while (i < this._chainCache.length) {
                    if (this._chainCache[i] != null) {
                        this._chainCache[i].clear();
                    }
                    ++i;
                }
            }
        }
        super.removeComponent(o);
    }

    @Override
    public void destroy() {
        Iterator iter = this._filterMap.values().iterator();
        while (iter.hasNext()) {
            Object sh = iter.next();
            iter.remove();
            this.removeComponent(sh);
        }
    }

    public static void main(String[] arg) {
        ServletHandler mServletHandler = new ServletHandler();
        ServletHolder servletHolder = mServletHandler.addServlet("/mPath", "wicket.protocol.http.WicketServlet");
        servletHolder.getServletContext().setAttribute("webApplication", "mWebApplication");
        servletHolder.getServletContext().setAttribute("applicationContext", "mApplicationContext");
        WebApplicationHandler mWebApplicationHandler = new WebApplicationHandler();
        ServletHolder servletHolder2 = mWebApplicationHandler.addServlet("/mpath", "wicket.protocol.http.WicketServlet");
        servletHolder2.getServletContext().setAttribute("webApplication", "mWebApplication");
        servletHolder2.getServletContext().setAttribute("applicationContext", "mApplicationContext");
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        ServletHolder _servletHolder;
        CachedChain _next;

        CachedChain(Object filters, ServletHolder servletHolder) {
            if (LazyList.size(filters) > 0) {
                this._filterHolder = (FilterHolder)LazyList.get(filters, 0);
                filters = LazyList.remove(filters, 0);
                this._next = new CachedChain(filters, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this._filterHolder != null) {
                if (log.isTraceEnabled()) {
                    log.trace("call filter " + this._filterHolder);
                }
                Filter filter = this._filterHolder.getFilter();
                filter.doFilter(request, response, this._next);
                return;
            }
            if (this._servletHolder != null) {
                if (log.isTraceEnabled()) {
                    log.trace("call servlet " + this._servletHolder);
                }
                this._servletHolder.handle(request, response);
            } else {
                WebApplicationHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return this._filterHolder + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }

    private class Chain
    implements FilterChain {
        int _filter = 0;
        Object _filters;
        ServletHolder _servletHolder;

        Chain(Object filters, ServletHolder servletHolder) {
            this._filters = filters;
            this._servletHolder = servletHolder;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (log.isTraceEnabled()) {
                log.trace("doFilter " + this._filter);
            }
            if (this._filter < LazyList.size(this._filters)) {
                FilterHolder holder = (FilterHolder)LazyList.get(this._filters, this._filter++);
                if (log.isTraceEnabled()) {
                    log.trace("call filter " + holder);
                }
                Filter filter = holder.getFilter();
                filter.doFilter(request, response, this);
                return;
            }
            if (this._servletHolder != null) {
                if (log.isTraceEnabled()) {
                    log.trace("call servlet " + this._servletHolder);
                }
                this._servletHolder.handle(request, response);
            } else {
                WebApplicationHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < LazyList.size(this._filters)) {
                b.append(LazyList.get(this._filters, i).toString());
                b.append("->");
                ++i;
            }
            b.append(this._servletHolder);
            return b.toString();
        }
    }

    private static class FilterMapping {
        private String _pathSpec;
        private FilterHolder _holder;
        private int _dispatches;

        FilterMapping(String pathSpec, FilterHolder holder, int dispatches) {
            this._pathSpec = pathSpec;
            this._holder = holder;
            this._dispatches = dispatches;
        }

        FilterHolder getHolder() {
            return this._holder;
        }

        boolean appliesTo(String path, int type) {
            boolean b = ((this._dispatches & type) != 0 || this._dispatches == 0 && type == 1) && (this._pathSpec == null || PathMap.match(this._pathSpec, path, true));
            return b;
        }
    }
}

