/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.http;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.security.auth.Subject;
import mx4j.remote.NotificationTuple;
import mx4j.remote.RemoteNotificationServerHandler;
import mx4j.tools.remote.AbstractServerInvoker;
import mx4j.tools.remote.http.HTTPConnection;

public class HTTPServerInvoker
extends AbstractServerInvoker
implements HTTPConnection {
    private final RemoteNotificationServerHandler notificationHandler;

    public HTTPServerInvoker(MBeanServerConnection server, RemoteNotificationServerHandler handler) {
        super(server);
        this.notificationHandler = handler;
    }

    public String connect(Object credentials) throws IOException, SecurityException {
        return null;
    }

    public void close() throws IOException {
        NotificationTuple[] tuples = this.notificationHandler.close();
        for (int i = 0; i < tuples.length; ++i) {
            NotificationTuple tuple = tuples[i];
            try {
                this.getServer().removeNotificationListener(tuple.getObjectName(), tuple.getNotificationListener(), tuple.getNotificationFilter(), tuple.getHandback());
                continue;
            }
            catch (InstanceNotFoundException ignored) {
                continue;
            }
            catch (ListenerNotFoundException ignored) {
                // empty catch block
            }
        }
    }

    public Integer addNotificationListener(ObjectName name, Object filter, Subject delegate) throws InstanceNotFoundException, IOException {
        Integer id = this.notificationHandler.generateListenerID(name, null);
        NotificationListener listener = this.notificationHandler.getServerNotificationListener();
        this.getServer().addNotificationListener(name, listener, null, (Object)id);
        this.notificationHandler.addNotificationListener(id, new NotificationTuple(name, listener, null, id));
        return id;
    }

    public void removeNotificationListeners(ObjectName name, Integer[] listenerIDs, Subject delegate) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        for (int i = 0; i < listenerIDs.length; ++i) {
            Integer id = listenerIDs[i];
            NotificationTuple tuple = this.notificationHandler.removeNotificationListener(id);
            this.getServer().removeNotificationListener(name, tuple.getNotificationListener(), tuple.getNotificationFilter(), tuple.getHandback());
        }
    }

    public NotificationResult fetchNotifications(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException {
        return this.notificationHandler.fetchNotifications(clientSequenceNumber, maxNotifications, timeout);
    }
}

