/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.server.handler;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.seleniumhq.jetty9.server.handler.ContextHandler;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;
import org.seleniumhq.jetty9.util.resource.Resource;

public class AllowSymLinkAliasChecker
implements ContextHandler.AliasCheck {
    private static final Logger LOG = Log.getLogger(AllowSymLinkAliasChecker.class);

    @Override
    public boolean check(String path, Resource resource) {
        try {
            File file = resource.getFile();
            if (file == null) {
                return false;
            }
            if (file.exists()) {
                URI real = file.toPath().toRealPath(new LinkOption[0]).toUri();
                if (real.equals(resource.getAlias())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Allow symlink {} --> {}", resource, real);
                    }
                    return true;
                }
            } else {
                Path p = file.toPath().toAbsolutePath();
                File d = p.getRoot().toFile();
                for (Path e : p) {
                    d = new File(d, e.toString());
                    while (d.exists() && Files.isSymbolicLink(d.toPath())) {
                        Path link = Files.readSymbolicLink(d.toPath());
                        if (!link.isAbsolute()) {
                            link = link.resolve(d.toPath());
                        }
                        d = link.toFile().getAbsoluteFile().getCanonicalFile();
                    }
                }
                if (resource.getAlias().equals(d.toURI())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Allow symlink {} --> {}", resource, d);
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.ignore(e);
        }
        return false;
    }
}

