/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.servlets.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.seleniumhq.jetty9.servlets.gzip.AbstractCompressedStream;
import org.seleniumhq.jetty9.util.StringUtil;

public abstract class CompressedResponseWrapper
extends HttpServletResponseWrapper {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIN_COMPRESS_SIZE = 256;
    private Set<String> _mimeTypes;
    private boolean _excludeMimeTypes;
    private int _bufferSize = 8192;
    private int _minCompressSize = 256;
    protected HttpServletRequest _request;
    private PrintWriter _writer;
    private AbstractCompressedStream _compressedStream;
    private String _etag;
    private long _contentLength = -1L;
    private boolean _noCompression;

    public CompressedResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this._request = request;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    public int getMinCompressSize() {
        return this._minCompressSize;
    }

    public String getETag() {
        return this._etag;
    }

    public HttpServletRequest getRequest() {
        return this._request;
    }

    public void setMimeTypes(Set<String> mimeTypes, boolean excludeMimeTypes) {
        this._excludeMimeTypes = excludeMimeTypes;
        this._mimeTypes = mimeTypes;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
        if (this._compressedStream != null) {
            this._compressedStream.setBufferSize(bufferSize);
        }
    }

    public void setMinCompressSize(int minCompressSize) {
        this._minCompressSize = minCompressSize;
    }

    @Override
    public void setContentType(String ct) {
        super.setContentType(ct);
        if (!(this._noCompression || this._compressedStream != null && this._compressedStream.getOutputStream() != null || ct == null)) {
            int colon = ct.indexOf(";");
            if (colon > 0) {
                ct = ct.substring(0, colon);
            }
            if (this._mimeTypes.contains(StringUtil.asciiToLowerCase(ct)) == this._excludeMimeTypes) {
                this.noCompression();
            }
        }
    }

    @Override
    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        if (sc < 200 || sc == 204 || sc == 205 || sc >= 300) {
            this.noCompression();
        }
    }

    @Override
    public void setStatus(int sc) {
        super.setStatus(sc);
        if (sc < 200 || sc == 204 || sc == 205 || sc >= 300) {
            this.noCompression();
        }
    }

    @Override
    public void setContentLength(int length) {
        if (this._noCompression) {
            super.setContentLength(length);
        } else {
            this.setContentLength((long)length);
        }
    }

    protected void setContentLength(long length) {
        this._contentLength = length;
        if (this._compressedStream != null) {
            this._compressedStream.setContentLength();
        } else if (this._noCompression && this._contentLength >= 0L) {
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            if (this._contentLength < Integer.MAX_VALUE) {
                response.setContentLength((int)this._contentLength);
            } else {
                response.setHeader("Content-Length", Long.toString(this._contentLength));
            }
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this._contentLength = Long.parseLong(value);
            if (this._compressedStream != null) {
                this._compressedStream.setContentLength();
            }
        } else if ("content-type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if ("content-encoding".equalsIgnoreCase(name)) {
            super.addHeader(name, value);
            if (!this.isCommitted()) {
                this.noCompression();
            }
        } else if ("etag".equalsIgnoreCase(name)) {
            this._etag = value;
        } else {
            super.addHeader(name, value);
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._compressedStream != null) {
            this._compressedStream.flush();
        } else {
            this.getResponse().flushBuffer();
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this._compressedStream != null) {
            this._compressedStream.resetBuffer();
        }
        this._writer = null;
        this._compressedStream = null;
        this._noCompression = false;
        this._contentLength = -1L;
    }

    @Override
    public void resetBuffer() {
        super.resetBuffer();
        if (this._compressedStream != null) {
            this._compressedStream.resetBuffer();
        }
        this._writer = null;
        this._compressedStream = null;
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.resetBuffer();
        super.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.resetBuffer();
        super.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.resetBuffer();
        super.sendRedirect(location);
    }

    public void noCompression() {
        if (!this._noCompression) {
            this.setDeferredHeaders();
        }
        this._noCompression = true;
        if (this._compressedStream != null) {
            try {
                this._compressedStream.doNotCompress(false);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void finish() throws IOException {
        if (this._writer != null && !this._compressedStream.isClosed()) {
            this._writer.flush();
        }
        if (this._compressedStream != null) {
            this._compressedStream.finish();
        } else {
            this.setDeferredHeaders();
        }
    }

    private void setDeferredHeaders() {
        if (!this.isCommitted()) {
            if (this._contentLength >= 0L) {
                if (this._contentLength < Integer.MAX_VALUE) {
                    super.setContentLength((int)this._contentLength);
                } else {
                    super.setHeader("Content-Length", Long.toString(this._contentLength));
                }
            }
            if (this._etag != null) {
                super.setHeader("ETag", this._etag);
            }
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (this._noCompression) {
            super.setHeader(name, value);
        } else if ("content-length".equalsIgnoreCase(name)) {
            this.setContentLength(Long.parseLong(value));
        } else if ("content-type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if ("content-encoding".equalsIgnoreCase(name)) {
            super.setHeader(name, value);
            if (!this.isCommitted()) {
                this.noCompression();
            }
        } else if ("etag".equalsIgnoreCase(name)) {
            this._etag = value;
        } else {
            super.setHeader(name, value);
        }
    }

    @Override
    public boolean containsHeader(String name) {
        if (!this._noCompression && "etag".equalsIgnoreCase(name) && this._etag != null) {
            return true;
        }
        return super.containsHeader(name);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this._compressedStream == null) {
            if (this.getResponse().isCommitted() || this._noCompression) {
                return this.getResponse().getOutputStream();
            }
            this._compressedStream = this.newCompressedStream(this._request, (HttpServletResponse)this.getResponse());
        } else if (this._writer != null) {
            throw new IllegalStateException("getWriter() called");
        }
        return this._compressedStream;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this._writer == null) {
            if (this._compressedStream != null) {
                throw new IllegalStateException("getOutputStream() called");
            }
            if (this.getResponse().isCommitted() || this._noCompression) {
                return this.getResponse().getWriter();
            }
            this._compressedStream = this.newCompressedStream(this._request, (HttpServletResponse)this.getResponse());
            this._writer = this.newWriter(this._compressedStream, this.getCharacterEncoding());
        }
        return this._writer;
    }

    @Override
    public void setIntHeader(String name, int value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this._contentLength = value;
            if (this._compressedStream != null) {
                this._compressedStream.setContentLength();
            }
        } else {
            super.setIntHeader(name, value);
        }
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }

    protected abstract AbstractCompressedStream newCompressedStream(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
}

