/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CircularOutputStream
extends OutputStream {
    private static final int DEFAULT_SIZE = 4096;
    private int start;
    private int end;
    private boolean filled = false;
    private byte[] buffer;
    private FileOutputStream out_log;

    public CircularOutputStream(File outputFile, int maxSize) {
        this.buffer = new byte[maxSize];
        if (outputFile != null) {
            try {
                this.out_log = new FileOutputStream(outputFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.out_log = null;
            }
        }
    }

    public CircularOutputStream(File outputFile) {
        this(outputFile, 4096);
    }

    public CircularOutputStream(int maxSize) {
        this(null, maxSize);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.end == this.buffer.length) {
            this.filled = true;
            this.end = 0;
        }
        if (this.filled && this.end == this.start) {
            this.start = this.start == this.buffer.length - 1 ? 0 : this.start + 1;
        }
        this.buffer[this.end++] = (byte)b;
        if (this.out_log != null) {
            this.out_log.write(b);
        }
    }

    public String toString() {
        int size = this.filled ? this.buffer.length : this.end;
        byte[] toReturn = new byte[size];
        if (!this.filled) {
            System.arraycopy(this.buffer, 0, toReturn, 0, this.end);
            return new String(toReturn);
        }
        int copyStart = this.buffer.length - this.start;
        if (copyStart == this.buffer.length) {
            copyStart = 0;
        }
        System.arraycopy(this.buffer, this.start, toReturn, 0, copyStart);
        System.arraycopy(this.buffer, 0, toReturn, copyStart, this.end);
        return new String(toReturn);
    }
}

