/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.remote.ConnectionResolver;
import mx4j.tools.remote.AbstractJMXConnectorServer;
import mx4j.tools.remote.ConnectionManager;
import mx4j.tools.remote.http.HTTPConnectionManager;
import mx4j.tools.remote.http.WebContainer;

public class HTTPConnectorServer
extends AbstractJMXConnectorServer {
    public static final String WEB_CONTAINER_CONFIGURATION = "jmx.remote.x.http.server.configuration";
    public static final String USE_EXTERNAL_WEB_CONTAINER = "jmx.remote.x.http.use.external.web.container";
    public static final String EMBEDDED_WEB_CONTAINER_CLASS = "jmx.remote.x.http.embedded.web.container.class";
    private static Map instances = new HashMap();
    private WebContainer webContainer;
    private ConnectionManager connectionManager;
    static /* synthetic */ Class class$mx4j$tools$remote$http$HTTPConnectorServer;

    public HTTPConnectorServer(JMXServiceURL url, Map environment, MBeanServer server) {
        super(url, environment, server);
    }

    protected void doStart() throws IOException, IllegalStateException {
        Map environment;
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            throw new IllegalStateException("This JMXConnectorServer is not attached to an MBeanServer");
        }
        JMXServiceURL address = this.getAddress();
        String protocol = address.getProtocol();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, environment = this.getEnvironment());
        if (resolver == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        this.webContainer = (WebContainer)resolver.createServer(address, environment);
        this.setAddress(resolver.bindServer(this.webContainer, address, environment));
        this.connectionManager = this.createConnectionManager(this, address, environment);
        this.register(this.getAddress(), this.connectionManager);
    }

    protected ConnectionManager createConnectionManager(AbstractJMXConnectorServer server, JMXServiceURL url, Map environment) {
        return new HTTPConnectionManager(server, url.getProtocol(), environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(JMXServiceURL url, ConnectionManager manager) throws IOException {
        Class clazz = class$mx4j$tools$remote$http$HTTPConnectorServer == null ? (class$mx4j$tools$remote$http$HTTPConnectorServer = HTTPConnectorServer.class$("mx4j.tools.remote.http.HTTPConnectorServer")) : class$mx4j$tools$remote$http$HTTPConnectorServer;
        synchronized (clazz) {
            if (instances.get(url) != null) {
                throw new IOException("A JMXConnectorServer is already serving at address " + url);
            }
            instances.put(url, manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(JMXServiceURL url) throws IOException {
        Class clazz = class$mx4j$tools$remote$http$HTTPConnectorServer == null ? (class$mx4j$tools$remote$http$HTTPConnectorServer = HTTPConnectorServer.class$("mx4j.tools.remote.http.HTTPConnectorServer")) : class$mx4j$tools$remote$http$HTTPConnectorServer;
        synchronized (clazz) {
            Object removed = instances.remove(url);
            if (removed == null) {
                throw new IOException("No JMXConnectorServer is present for address " + url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ConnectionManager find(JMXServiceURL address) {
        Class clazz = class$mx4j$tools$remote$http$HTTPConnectorServer == null ? (class$mx4j$tools$remote$http$HTTPConnectorServer = HTTPConnectorServer.class$("mx4j.tools.remote.http.HTTPConnectorServer")) : class$mx4j$tools$remote$http$HTTPConnectorServer;
        synchronized (clazz) {
            ConnectionManager manager = (ConnectionManager)instances.get(address);
            if (manager != null) {
                return manager;
            }
            Logger logger = Log.getLogger((class$mx4j$tools$remote$http$HTTPConnectorServer == null ? (class$mx4j$tools$remote$http$HTTPConnectorServer = HTTPConnectorServer.class$("mx4j.tools.remote.http.HTTPConnectorServer")) : class$mx4j$tools$remote$http$HTTPConnectorServer).getName());
            if (logger.isEnabledFor(10)) {
                logger.debug("Known HTTPConnectorServers bound at " + instances.keySet());
            }
            return null;
        }
    }

    protected void doStop() throws IOException {
        Map environment;
        String protocol;
        ConnectionResolver resolver;
        JMXServiceURL url = this.getAddress();
        this.unregister(url);
        if (this.connectionManager != null) {
            this.connectionManager.close();
            this.connectionManager = null;
        }
        if ((resolver = ConnectionResolver.newConnectionResolver(protocol = url.getProtocol(), environment = this.getEnvironment())) == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        resolver.unbindServer(this.webContainer, url, environment);
        resolver.destroyServer(this.webContainer, url, environment);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

