/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.FirefoxLocator;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionFirefoxCustomProfileLauncher;

public class FirefoxLauncher
implements BrowserLauncher {
    final BrowserLauncher realLauncher;

    public FirefoxLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) throws InvalidBrowserExecutableException {
        BrowserInstallation installation;
        String browserName = "firefox";
        FirefoxLocator locator = new FirefoxLocator();
        String mode = (String)browserOptions.getCapability("mode");
        if (mode == null) {
            mode = "chrome";
        }
        if ("default".equals(mode)) {
            mode = "chrome";
        }
        if ((installation = ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation(browserName, browserLaunchLocation, locator)) == null) {
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
        if ("chrome".equals(mode)) {
            this.realLauncher = new FirefoxChromeLauncher(browserOptions, configuration, sessionId, installation);
            return;
        }
        boolean proxyInjectionMode = browserOptions.is("proxyInjectionMode") || "proxyInjection".equals(mode);
        boolean globalProxyInjectionMode = configuration.getProxyInjectionModeArg();
        if (proxyInjectionMode && !globalProxyInjectionMode && proxyInjectionMode) {
            throw new RuntimeException("You requested proxy injection mode, but this server wasn't configured with -proxyInjectionMode on the command line");
        }
        proxyInjectionMode = globalProxyInjectionMode;
        if (proxyInjectionMode) {
            this.realLauncher = new ProxyInjectionFirefoxCustomProfileLauncher(browserOptions, configuration, sessionId, installation);
            return;
        }
        if (!"proxy".equals(mode)) {
            throw new RuntimeException("Unrecognized browser mode: " + mode);
        }
        this.realLauncher = new FirefoxCustomProfileLauncher(browserOptions, configuration, sessionId, installation);
    }

    @Override
    public void close() {
        this.realLauncher.close();
    }

    @Override
    public void launchHTMLSuite(String suiteUrl, String baseUrl) {
        this.realLauncher.launchHTMLSuite(suiteUrl, baseUrl);
    }

    @Override
    public void launchRemoteSession(String url) {
        this.realLauncher.launchRemoteSession(url);
    }
}

