/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.logging.Logger;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.SingleEntryAsyncQueue;

public class CommandHolder {
    private static final Logger log = Logger.getLogger(CommandHolder.class.getName());
    private static final int defaultTimeout = 10;
    private static final RemoteCommand poisonCommand = new DefaultRemoteCommand("CommandHolder.POISON", "", "");
    protected static final String RETRY_CMD_STRING = "retryLast";
    protected static final RemoteCommand retryCommand = new DefaultRemoteCommand("retryLast", "", "", "");
    private final String queueId;
    private final SingleEntryAsyncQueue<RemoteCommand> queue;

    public CommandHolder(String queueId) {
        this(queueId, 10);
    }

    public CommandHolder(String queueId, int timeoutInSeconds) {
        this.queueId = queueId;
        this.queue = new SingleEntryAsyncQueue(timeoutInSeconds);
        this.queue.setPoison(poisonCommand);
    }

    public RemoteCommand getCommand() {
        log.fine(String.valueOf(this.hdr()) + "called");
        RemoteCommand command = this.queue.pollToGetContentUntilTimeout();
        if (command == null) {
            command = retryCommand;
        } else if (this.queue.isPoison(command)) {
            command = null;
        }
        log.fine(String.valueOf(this.hdr()) + "-> " + (command == null ? "null" : command.toString()));
        return command;
    }

    public boolean putCommand(RemoteCommand cmd) {
        log.fine(this.hdr());
        return this.queue.putContent(cmd);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public RemoteCommand peek() {
        return this.queue.peek();
    }

    public void poisonPollers() {
        log.fine(String.valueOf(this.hdr()) + " poisoning pollers");
        this.queue.poisonPollers();
    }

    private String hdr() {
        return "\t" + CommandQueue.getIdentification("commandHolder", this.queueId) + " getCommand() ";
    }
}

