﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//using System.Threading;

namespace ProgramowanieRownolegle
{
    class Program
    {
        static private double obliczenia(double argument)
        {
            for (int i = 0; i < 10; ++i)
            {
                argument = Math.Asin(Math.Sin(argument));
            }
            return argument;
        }

        static void ParallelFor()
        {
            //przygotowania 
            int rozmiar = 10000;
            Random r = new Random();
            double[] tablica = new double[rozmiar];
            for (int i = 0; i < tablica.Length; ++i) tablica[i] = r.NextDouble();

            //obliczenia sekwencyjne
            int liczbaPowtorzen = 100;
            double[] wyniki = new double[tablica.Length];
            int start = System.Environment.TickCount;
            for (int powtorzenia = 0; powtorzenia < liczbaPowtorzen; ++powtorzenia)
                for (int i = 0; i < tablica.Length; ++i)
                    wyniki[i] = obliczenia(tablica[i]);
            int stop = System.Environment.TickCount;
            Console.WriteLine("Obliczenia sekwencyjne trwały " + (stop - start).ToString() + " ms.");

            //obliczenia równoległe
            start = System.Environment.TickCount;
            for (int powtorzenia = 0; powtorzenia < liczbaPowtorzen; ++powtorzenia)
            {
                Parallel.For(0, tablica.Length, (int i) => wyniki[i] = obliczenia(tablica[i]));
            }
            stop = System.Environment.TickCount;
            Console.WriteLine("Obliczenia równoległe trwały " + (stop - start).ToString() + " ms.");

            /*
            //prezentacja wyników 
            Console.WriteLine("Wyniki:");
            for (long i = 0; i < tablica.Length; ++i) Console.WriteLine(i + ". " + tablica[i] + " ?= " + wyniki[i]);
            */
        }

        static void PrzerywaniePetli()
        {
            Random r = new Random();
            long suma = 0;
            long licznik = 0;
            string s = "";

            //iteracje zostaną wykonane tylko dla liczb parzystych
            //pętla zostanie przerwana wcześniej, jeżeli wylosowana liczba jest równa 0
            Parallel.For(0, 10000, (int i, ParallelLoopState stanPetli) =>
            {
                int liczba = r.Next(7); //losowanie liczby oczek na kostce                    
                if (liczba == 0)
                {
                    s += "Stop:";
                    stanPetli.Stop();
                }
                if (stanPetli.IsStopped) return;
                if (liczba % 2 == 0)
                {
                    s += liczba.ToString() + "; ";
                    obliczenia(liczba);
                    suma += liczba;
                    licznik++;
                }
                else s += "[" + liczba.ToString() + "]; ";
            });

            Console.WriteLine(
               "Wylosowane liczby: " + s +
               "\nLiczba pasujących liczb: " + licznik +
               "\nSuma: " + suma +
               "\nŚrednia: " + (suma / (double)licznik).ToString());
        }

        static void ProgramowanieAsynchroniczne_Synchronicznie()
        {
            //czynność
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek działania akcji - " + argument.ToString());
                    System.Threading.Thread.Sleep(500); //opóźnienie 0,5s
                    Console.WriteLine("Koniec działania akcji - " + argument.ToString());
                    return DateTime.Now.Ticks;
                };

            //synchronicznie
            long wynik = akcja("synchronicznie");
            Console.WriteLine("Synchronicznie: " + wynik.ToString());
        }

        static void ProgramowanieAsynchroniczne_Zadanie()
        {
            //czynność
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek działania akcji - " + argument.ToString());
                    System.Threading.Thread.Sleep(500); //opóźnienie 0,5s
                    Console.WriteLine("Koniec działania akcji - " + argument.ToString());
                    return DateTime.Now.Ticks;
                };

            //w osobnym zadaniu
            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            Console.WriteLine("Akcja została uruchomiona");
            //właściwość Result czeka ze zwróceniem wartości, aż zadanie zostanie zakończone 
            //(synchronizacja)
            long wynik = zadanie.Result;
            Console.WriteLine("Zadanie: " + wynik.ToString());
        }

        static private Task<long> ZróbCośAsync(object argument)
        {
            //czynność, która będzie wykonywana asynchronicznie
            Func<object, long> akcja =
                (object _argument) =>
                {
                    Console.WriteLine("Początek działania akcji - " + _argument.ToString());
                    System.Threading.Thread.Sleep(500); //opóźnienie 0,5s
                    Console.WriteLine("Koniec działania akcji - " + _argument.ToString());
                    return DateTime.Now.Ticks;
                };

            Task<long> zadanie = new Task<long>(akcja, argument);
            zadanie.Start();
            return zadanie;
        }

        static void ProgramowanieAsynchroniczne_Asynchronicznie()
        {
            Task<long> zadanie2 = ZróbCośAsync("zadanie-metoda");
            Console.WriteLine("Akcja została uruchomiona (metoda)");
            long wynik = zadanie2.Result;
            Console.WriteLine("Zadanie-metoda: " + wynik.ToString());
        }

        static async void ProgramowanieAsynchroniczne_Async()
        {            
            Task<long> zadanie2 = ZróbCośAsync("zadanie-metoda");
            Console.WriteLine("Akcja została uruchomiona (metoda)");
            long wynik = await zadanie2;
            Console.WriteLine("Zadanie-metoda: " + wynik.ToString());
        }

        static void Main(string[] args)
        {
            ParallelFor(); Console.WriteLine();
            PrzerywaniePetli(); Console.WriteLine();
            ProgramowanieAsynchroniczne_Synchronicznie(); Console.WriteLine();
            ProgramowanieAsynchroniczne_Zadanie(); Console.WriteLine();
            ProgramowanieAsynchroniczne_Asynchronicznie(); Console.WriteLine();
            ProgramowanieAsynchroniczne_Async(); Console.WriteLine("Koniec.");

            Console.Write("Naciśnij Enter..."); Console.ReadLine();
        }
    }
}
