﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Data.Entity;

namespace AplikacjaZBazaDanych
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            using(AdresyEntities bazaDanychAdresy = new AdresyEntities())
            {
                //prezentacja oryginalnych danych
                string s = "Lista osób:\n";
                foreach (Osoba o in bazaDanychAdresy.Osoby) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
                MessageBox.Show(s);

                //tworzenie nowego rekordu
                int noweId = bazaDanychAdresy.Osoby.Max(o => o.Id) + 1;
                Osoba nowaOsoba = new Osoba() 
                { 
                    Id = noweId, 
                    Imię = "Antoni", 
                    Nazwisko = "Gburek", 
                    Wiek = 45, 
                    Email = "ag@firma.pl", 
                    NumerTelefonu = 123456789 
                };

                //dodanie rekordu do bazy i zapisanie zmian
                bazaDanychAdresy.Osoby.Add(nowaOsoba);
                bazaDanychAdresy.SaveChanges();
                
                //prezentacja zmodyfikowanych danych
                s = "Lista osób:\n";
                foreach (Osoba o in bazaDanychAdresy.Osoby) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
                MessageBox.Show(s);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            using (AdresyEntities bazaDanychAdresy = new AdresyEntities())
            {
                //zapytanie LINQ to Entities
                var osobyPelnoletnie = from o in bazaDanychAdresy.Osoby
                                       select o;
                
                //prezentacja wyników zapytania
                string s = "Lista osób pełnoletnich:\n";
                foreach (Osoba o in osobyPelnoletnie) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
                MessageBox.Show(s);                

                //--------------------------

                //zapytanie LINQ to Entities
                var zredukowaneOsobyPelnoletnie = from o in bazaDanychAdresy.Osoby
                                                  select new { o.Imię, o.Nazwisko, o.Wiek };

                //prezentacja wyników zapytania
                s = "Lista osób pełnoletnich:\n";
                foreach (var o in zredukowaneOsobyPelnoletnie) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")\n";
                MessageBox.Show(s);

                //--------------------------

                //zapytanie LINQ to Objects
                var personaliaOsobPelnoletnich = from o in bazaDanychAdresy.Osoby.ToList()
                                                 select o.Imię + " " + o.Nazwisko + " (" + o.Wiek + ")";

                //prezentacja wyników zapytania
                s = "Lista osób pełnoletnich:\n";
                foreach (string p in personaliaOsobPelnoletnich) s += p + "\n";
                MessageBox.Show(s);                
            }
        }

        //--------------------------

        AdresyEntities bazaDanychAdresy;
        bool daneZmienione;

        private async void Form1_Load(object sender, EventArgs e)
        {
            bazaDanychAdresy = new AdresyEntities();
            
            await bazaDanychAdresy.Osoby.LoadAsync();
            dataGridView1.DataSource = bazaDanychAdresy.Osoby.Local.ToBindingList<Osoba>();

            //await bazaDanychAdresy.OsobyPelnoletnie.LoadAsync();
            //dataGridView2.DataSource = bazaDanychAdresy.OsobyPelnoletnie.Local.ToBindingList<OsobyPelnoletnie>();

            dataGridView2.DataSource = bazaDanychAdresy.ListaOsobPelnoletnich();

            daneZmienione = false;
        }

        private void dataGridView1_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            daneZmienione = true;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!daneZmienione) return;
            switch (MessageBox.Show("Czy zapisać zmiany do bazy danych?", this.Text, MessageBoxButtons.YesNoCancel))
            {
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
                case DialogResult.Yes:
                    try
                    {
                        this.Validate();
                        bazaDanychAdresy.SaveChanges();                        
                        bazaDanychAdresy.Dispose();
                    }
                    catch (Exception exc)
                    {
                        MessageBox.Show("Zapisanie danych nie powiodło się (" + exc.Message + ")");
                    }
                    break;
                case DialogResult.No:
                    break;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            bazaDanychAdresy.AktualizujWiek();
            Form1_Load(null, null);
        }
    }
}
