﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Para
{
    class Para<T> : IComparable<Para<T>> where T : IComparable<T>
    {
        private T pierwszy = default(T), drugi = default(T);

        public Para(T pierwszy, T drugi)
        {
            this.pierwszy = pierwszy;
            this.drugi = drugi;
        }

        public override string ToString()
        {
            return pierwszy.ToString() + "\t" + drugi.ToString();
        }

        public int CompareTo(Para<T> innaPara)
        {
            int wartosc = this.pierwszy.CompareTo(innaPara.pierwszy);
            if (wartosc != 0) return wartosc;
            else return this.drugi.CompareTo(innaPara.drugi);
        }
    }
}
