﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CheckedTest
{
    class Program
    {
        static private int sumowanie(int i1, int i2)
        {
            return i1 + i2;
        }

        static void Main(string[] args)
        {
            int i = int.MaxValue / 3 * 2; //dodanie const spowoduje weryfikację przekroczenia zakresu podczas kompilacji
            Console.WriteLine("i=" + i + ", int.MaxValue=" + int.MaxValue);

            int wynik = i + i;
            Console.WriteLine("i+i=" + wynik);

            try
            {
                wynik = checked(i + i);
                Console.WriteLine("i+i=" + wynik);
            }
            catch (OverflowException exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }

            try
            {
                wynik = checked(sumowanie(i, i));
                Console.WriteLine("sumowanie(i,i)=" + wynik);
            }
            catch (OverflowException exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }
        }
    }
}
