﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//using System.Threading;

namespace ProgramowanieRownolegle
{
    class Program
    {
        static void Console_WriteLine(string tekst)
        {
            string numerWątku = System.Threading.Thread.CurrentThread.ManagedThreadId.ToString();
            string numerZadania = Task.CurrentId.HasValue?Task.CurrentId.Value.ToString():"-";
            Console.WriteLine("[wątek: " + numerWątku + ", zadanie: " + numerZadania + "] " + tekst);
        }

        static private Task<long> ZróbCośAsync(object argument)
        {
            Console_WriteLine("ZróbCośAsync - Początek");
            //czynność, która będzie wykonywana asynchronicznie
            Func<object, long> akcja =
                (object _argument) =>
                {
                    Console_WriteLine("Początek działania akcji - " + _argument.ToString());
                    System.Threading.Thread.Sleep(500); //opóźnienie 0,5s
                    Console_WriteLine("Koniec działania akcji - " + _argument.ToString());
                    return DateTime.Now.Ticks;
                };

            Task<long> zadanie = new Task<long>(akcja, argument);
            zadanie.Start();
            Console_WriteLine("ZróbCośAsync - Koniec, zadanie uruchomione");
            return zadanie;
        }

        static async void ProgramowanieAsynchroniczne()
        {
            Console_WriteLine("ProgramowanieAsynchroniczne - Początek");
            Task<long> zadanie2 = ZróbCośAsync("zadanie-metoda");
            Console_WriteLine("ProgramowanieAsynchroniczne - Akcja została uruchomiona");
            long wynik = await zadanie2;
            Console_WriteLine("ProgramowanieAsynchroniczne - koniec, wynik: " + wynik.ToString());
        }

        static void Main(string[] args)
        {
            Console_WriteLine("Main - Początek");
            ProgramowanieAsynchroniczne(); 
            Console_WriteLine("Main - Koniec, Naciśnij Enter..."); Console.ReadLine();
        }
    }
}
