﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Cards
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda ShowCard() akceptuje ciąg tekstowy wraz
        // z nazwą karty, którą następnie wyświetla. 
        private void ShowCard(string card)
        {
            switch (card) 
            {
                case "As pik" :
                    ShowAceSpades();
                    break;
                case "10 kier":
                    ShowTenHearts();
                    break;
                case "Król trefl":
                    ShowKingClubs();
                    break;
            }
        } 

        // Metoda ShowAceSpades() powoduje wyświetlenie 
        // karty As pik i ukrycie pozostałych. 
        private void ShowAceSpades()
        {
            aceSpadesPictureBox.Visible = true; 
            tenHeartsPictureBox.Visible = false; 
            kingClubsPictureBox.Visible = false; 
        } 

        // Metoda ShowTenHearts() powoduje wyświetlenie
        // karty 10 kier i ukrycie pozostałych. 
        private void ShowTenHearts()
        {
            tenHeartsPictureBox.Visible = true; 
            aceSpadesPictureBox.Visible = false; 
            kingClubsPictureBox.Visible = false; 
        } 

        // Metoda ShowKingClubs() powoduje wyświetlenie
        // karty Król trefl i ukrycie pozostałych. 
        private void ShowKingClubs()
        {
            kingClubsPictureBox.Visible = true; 
            aceSpadesPictureBox.Visible = false; 
            tenHeartsPictureBox.Visible = false; 
        }

        private void showCardButton_Click(object sender, EventArgs e)
        {
            // Jeżeli wybrano kartę w kontrolce ListBox, należy ją wyświetlić. 
            if (cardListBox.SelectedIndex != -1) 
            {
                ShowCard(cardListBox.SelectedItem.ToString());
            }
            else 
            {
                MessageBox.Show("Proszę wybrać dowolną " +
                                "kartę z listy.");
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
